/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.http.apache;

import io.crnk.client.http.HttpAdapter;
import io.crnk.client.http.HttpAdapterRequest;
import io.crnk.client.http.apache.HttpClientAdapterListener;
import io.crnk.client.http.apache.HttpClientBuilderFactory;
import io.crnk.client.http.apache.HttpClientRequest;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class HttpClientAdapter
implements HttpAdapter {
    private CloseableHttpClient impl;
    private CopyOnWriteArrayList<HttpClientAdapterListener> listeners = new CopyOnWriteArrayList();
    private Integer receiveTimeout;

    public static HttpClientAdapter newInstance() {
        return new HttpClientAdapter();
    }

    public void addListener(HttpClientAdapterListener listener) {
        this.checkNotInitialized();
        this.listeners.add(listener);
    }

    private void checkNotInitialized() {
        if (this.impl != null) {
            throw new IllegalStateException("already initialized");
        }
    }

    public CloseableHttpClient getImplementation() {
        if (this.impl == null) {
            this.initImpl();
        }
        return this.impl;
    }

    private synchronized void initImpl() {
        if (this.impl == null) {
            HttpClientBuilder builder = this.createBuilder();
            if (this.receiveTimeout != null) {
                RequestConfig.Builder requestBuilder = RequestConfig.custom();
                requestBuilder = requestBuilder.setSocketTimeout(this.receiveTimeout.intValue());
                builder.setDefaultRequestConfig(requestBuilder.build());
            }
            for (HttpClientAdapterListener listener : this.listeners) {
                listener.onBuild(builder);
            }
            this.impl = builder.build();
        }
    }

    private HttpClientBuilder createBuilder() {
        HttpClientBuilder builder = null;
        for (HttpClientAdapterListener listener : this.listeners) {
            if (!(listener instanceof HttpClientBuilderFactory)) continue;
            PreconditionUtil.assertNull((String)"only one module can contribute a HttpClientBuilder with HttpClientBuilderFactory", builder);
            builder = ((HttpClientBuilderFactory)((Object)listener)).createBuilder();
        }
        if (builder != null) {
            return builder;
        }
        return HttpClients.custom();
    }

    @Override
    public HttpAdapterRequest newRequest(String url, HttpMethod method, String requestBody) {
        CloseableHttpClient implementation = this.getImplementation();
        return new HttpClientRequest(implementation, url, method, requestBody);
    }

    @Override
    public void setReceiveTimeout(int timeout, TimeUnit unit) {
        this.checkNotInitialized();
        this.receiveTimeout = (int)unit.toMillis(timeout);
    }
}

