/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.http.okhttp;

import io.crnk.client.http.HttpAdapter;
import io.crnk.client.http.HttpAdapterRequest;
import io.crnk.client.http.okhttp.OkHttpAdapterListener;
import io.crnk.client.http.okhttp.OkHttpRequest;
import io.crnk.core.engine.http.HttpMethod;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class OkHttpAdapter
implements HttpAdapter {
    private OkHttpClient impl;
    private CopyOnWriteArrayList<OkHttpAdapterListener> listeners = new CopyOnWriteArrayList();
    private Long networkTimeout;

    public static OkHttpAdapter newInstance() {
        return new OkHttpAdapter();
    }

    public void addListener(OkHttpAdapterListener listener) {
        this.checkNotInitialized();
        this.listeners.add(listener);
    }

    private void checkNotInitialized() {
        if (this.impl != null) {
            throw new IllegalStateException("already initialized");
        }
    }

    public OkHttpClient getImplementation() {
        if (this.impl == null) {
            this.initImpl();
        }
        return this.impl;
    }

    private synchronized void initImpl() {
        if (this.impl == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (this.networkTimeout != null) {
                builder.readTimeout(this.networkTimeout.longValue(), TimeUnit.MILLISECONDS);
            }
            for (OkHttpAdapterListener listener : this.listeners) {
                listener.onBuild(builder);
            }
            this.impl = builder.build();
        }
    }

    @Override
    public HttpAdapterRequest newRequest(String url, HttpMethod method, String requestBody) {
        OkHttpClient implementation = this.getImplementation();
        return new OkHttpRequest(implementation, url, method, requestBody);
    }

    @Override
    public void setReceiveTimeout(int timeout, TimeUnit unit) {
        this.checkNotInitialized();
        this.networkTimeout = unit.toMillis(timeout);
    }
}

