/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.http.okhttp;

import io.crnk.client.http.HttpAdapterRequest;
import io.crnk.client.http.HttpAdapterResponse;
import io.crnk.client.http.okhttp.OkHttpResponse;
import io.crnk.core.engine.http.HttpMethod;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpRequest
implements HttpAdapterRequest {
    private static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/vnd.api+json; charset=utf-8");
    private Request.Builder builder;
    private OkHttpClient client;

    public OkHttpRequest(OkHttpClient client, String url, HttpMethod method, String requestBody) {
        this.client = client;
        this.builder = new Request.Builder().url(url);
        RequestBody requestBodyObj = requestBody != null ? RequestBody.create((MediaType)CONTENT_TYPE, (String)requestBody) : null;
        this.builder.method(method.toString(), requestBodyObj);
    }

    @Override
    public void header(String name, String value) {
        this.builder = this.builder.header(name, value);
    }

    @Override
    public HttpAdapterResponse execute() throws IOException {
        Request request = this.builder.build();
        Response response = this.client.newCall(request).execute();
        return new OkHttpResponse(response);
    }
}

