/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.client.internal.ClientResourceUpsert;
import io.crnk.client.internal.proxy.ClientProxyFactory;
import io.crnk.client.internal.proxy.ObjectProxy;
import io.crnk.client.response.JsonLinksInformation;
import io.crnk.client.response.JsonMetaInformation;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMapperUtil;
import io.crnk.core.engine.internal.document.mapper.ResourceMapper;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.resource.annotations.SerializeType;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.utils.Nullable;
import java.util.Collection;
import java.util.List;

public class ClientDocumentMapper
extends DocumentMapper {
    private ClientProxyFactory proxyFactory;
    private ObjectMapper objectMapper;
    private ResourceRegistry resourceRegistry;
    private TypeParser typeParser;

    public ClientDocumentMapper(ModuleRegistry moduleRegistry, ObjectMapper objectMapper, PropertiesProvider propertiesProvider) {
        super(moduleRegistry.getResourceRegistry(), objectMapper, propertiesProvider, null, true);
        this.resourceRegistry = moduleRegistry.getResourceRegistry();
        this.typeParser = moduleRegistry.getTypeParser();
        this.objectMapper = objectMapper;
    }

    protected ResourceMapper newResourceMapper(final DocumentMapperUtil util, boolean client, ObjectMapper objectMapper) {
        return new ResourceMapper(util, client, objectMapper, null){

            protected void setRelationship(Resource resource, ResourceField field, Object entity, ResourceInformation resourceInformation, QueryAdapter queryAdapter) {
                boolean includeRelation = true;
                Object relationshipValue = field.getAccessor().getValue(entity);
                if (relationshipValue instanceof ObjectProxy) {
                    includeRelation = ((ObjectProxy)relationshipValue).isLoaded();
                } else {
                    boolean bl = includeRelation = relationshipValue != null || field.getSerializeType() != SerializeType.LAZY && !field.isCollection();
                }
                if (includeRelation) {
                    Relationship relationship = new Relationship();
                    if (relationshipValue instanceof Collection) {
                        relationship.setData(Nullable.of((Object)util.toResourceIds((Collection)relationshipValue)));
                    } else {
                        relationship.setData(Nullable.of((Object)util.toResourceId(relationshipValue)));
                    }
                    resource.getRelationships().put(field.getJsonName(), relationship);
                }
            }
        };
    }

    public void setProxyFactory(ClientProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public Object fromDocument(Document document, boolean getList) {
        ClientResourceUpsert upsert = new ClientResourceUpsert(this.resourceRegistry, this.propertiesProvider, this.typeParser, this.objectMapper, null, this.proxyFactory);
        PreconditionUtil.assertFalse((String)"document contains json api errors and cannot be processed", (document.getErrors() != null && !document.getErrors().isEmpty() ? 1 : 0) != 0);
        if (!document.getData().isPresent()) {
            return null;
        }
        List included = document.getIncluded();
        List data = (List)document.getCollectionData().get();
        List<Object> dataObjects = upsert.allocateResources(data);
        if (included != null) {
            upsert.allocateResources(included);
        }
        upsert.setRelations(data);
        if (included != null) {
            upsert.setRelations(included);
        }
        if (getList) {
            DefaultResourceList resourceList = new DefaultResourceList();
            resourceList.addAll(dataObjects);
            if (document.getLinks() != null) {
                resourceList.setLinks((LinksInformation)new JsonLinksInformation((JsonNode)document.getLinks(), this.objectMapper));
            }
            if (document.getMeta() != null) {
                resourceList.setMeta((MetaInformation)new JsonMetaInformation((JsonNode)document.getMeta(), this.objectMapper));
            }
            return resourceList;
        }
        if (dataObjects.isEmpty()) {
            return null;
        }
        PreconditionUtil.assertFalse((String)"expected unique result", (dataObjects.size() > 1 ? 1 : 0) != 0);
        return dataObjects.get(0);
    }
}

