/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.crnk.client.ResponseBodyException;
import io.crnk.client.internal.proxy.ClientProxyFactory;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Relationship;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceUpsert;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.legacy.internal.RepositoryMethodParameterProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ClientResourceUpsert
extends ResourceUpsert {
    private ClientProxyFactory proxyFactory;
    private Map<String, Object> resourceMap = new HashMap<String, Object>();

    public ClientResourceUpsert(ResourceRegistry resourceRegistry, PropertiesProvider propertiesProvider, TypeParser typeParser, ObjectMapper objectMapper, DocumentMapper documentMapper, ClientProxyFactory proxyFactory) {
        super(resourceRegistry, propertiesProvider, typeParser, objectMapper, documentMapper, Collections.emptyList());
        this.proxyFactory = proxyFactory;
    }

    public String getUID(ResourceIdentifier id) {
        return id.getType() + "#" + id.getId();
    }

    public String getUID(RegistryEntry entry, Serializable id) {
        return entry.getResourceInformation().getResourceType() + "#" + id;
    }

    public void setRelations(List<Resource> resources) {
        for (Resource resource : resources) {
            String uid = this.getUID((ResourceIdentifier)resource);
            Object object = this.resourceMap.get(uid);
            RegistryEntry registryEntry = this.resourceRegistry.getEntry(resource.getType());
            QueryAdapter queryAdapter = null;
            RepositoryMethodParameterProvider parameterProvider = null;
            this.setRelations(object, registryEntry, resource, queryAdapter, parameterProvider, true);
        }
    }

    protected Object fetchRelatedObject(RegistryEntry entry, Serializable relationId, RepositoryMethodParameterProvider parameterProvider, QueryAdapter queryAdapter) {
        String uid = this.getUID(entry, relationId);
        Object relatedResource = this.resourceMap.get(uid);
        if (relatedResource != null) {
            return relatedResource;
        }
        ResourceInformation resourceInformation = entry.getResourceInformation();
        Class resourceClass = resourceInformation.getResourceClass();
        return this.proxyFactory.createResourceProxy(resourceClass, relationId);
    }

    public List<Object> allocateResources(List<Resource> resources) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Resource resource : resources) {
            RegistryEntry registryEntry = this.getRegistryEntry(resource.getType());
            ResourceInformation resourceInformation = registryEntry.getResourceInformation();
            Object object = this.newResource(resourceInformation, resource);
            this.setId(resource, object, resourceInformation);
            this.setAttributes(resource, object, resourceInformation);
            this.setLinks(resource, object, resourceInformation);
            this.setMeta(resource, object, resourceInformation);
            objects.add(object);
            String uid = this.getUID((ResourceIdentifier)resource);
            this.resourceMap.put(uid, object);
        }
        return objects;
    }

    protected void setLinks(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        ResourceField linksField = resourceInformation.getLinksField();
        if (dataBody.getLinks() != null && linksField != null) {
            ObjectNode linksNode = dataBody.getLinks();
            Class linksClass = linksField.getType();
            ObjectReader linksMapper = this.objectMapper.readerFor(linksClass);
            try {
                Object links = linksMapper.readValue((JsonNode)linksNode);
                linksField.getAccessor().setValue(instance, links);
            }
            catch (IOException e) {
                throw new ResponseBodyException("failed to parse links information", e);
            }
        }
    }

    protected void setMeta(Resource dataBody, Object instance, ResourceInformation resourceInformation) {
        ResourceField metaField = resourceInformation.getMetaField();
        if (dataBody.getMeta() != null && metaField != null) {
            ObjectNode metaNode = dataBody.getMeta();
            Class metaClass = metaField.getType();
            ObjectReader metaMapper = this.objectMapper.readerFor(metaClass);
            try {
                Object meta = metaMapper.readValue((JsonNode)metaNode);
                metaField.getAccessor().setValue(instance, meta);
            }
            catch (IOException e) {
                throw new ResponseBodyException("failed to parse links information", e);
            }
        }
    }

    public boolean isAcceptable(JsonPath jsonPath, String requestType) {
        throw new UnsupportedOperationException();
    }

    public Response handle(JsonPath jsonPath, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider, Document document) {
        throw new UnsupportedOperationException();
    }

    protected void setRelationsField(Object newResource, RegistryEntry registryEntry, Map.Entry<String, Relationship> property, QueryAdapter queryAdapter, RepositoryMethodParameterProvider parameterProvider) {
        Relationship relationship = property.getValue();
        if (!relationship.getData().isPresent()) {
            ObjectNode links = relationship.getLinks();
            if (links != null) {
                String fieldName = property.getKey();
                ResourceInformation resourceInformation = registryEntry.getResourceInformation();
                ResourceField field = resourceInformation.findRelationshipFieldByName(fieldName);
                Class elementType = field.getElementType();
                Class collectionClass = field.getType();
                JsonNode relatedNode = links.get("related");
                if (relatedNode != null) {
                    String url = relatedNode.asText().trim();
                    Object proxy = this.proxyFactory.createCollectionProxy(elementType, collectionClass, url);
                    field.getAccessor().setValue(newResource, proxy);
                }
            }
        } else {
            super.setRelationsField(newResource, registryEntry, property, queryAdapter, parameterProvider);
        }
    }

    protected boolean canModifyField(ResourceInformation resourceInformation, String fieldName, ResourceField field) {
        return true;
    }

    protected HttpMethod getHttpMethod() {
        throw new UnsupportedOperationException();
    }
}

