/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.client.ClientException;
import io.crnk.client.CrnkClient;
import io.crnk.client.TransportException;
import io.crnk.client.http.HttpAdapter;
import io.crnk.client.http.HttpAdapterRequest;
import io.crnk.client.http.HttpAdapterResponse;
import io.crnk.client.internal.ClientDocumentMapper;
import io.crnk.client.response.JsonLinksInformation;
import io.crnk.client.response.JsonMetaInformation;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.error.ErrorResponse;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.utils.JsonApiUrlBuilder;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.meta.MetaInformation;
import io.crnk.core.utils.Optional;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStubBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStubBase.class);
    protected CrnkClient client;
    protected JsonApiUrlBuilder urlBuilder;
    protected Class<?> resourceClass;

    public ClientStubBase(CrnkClient client, JsonApiUrlBuilder urlBuilder, Class<?> resourceClass) {
        this.client = client;
        this.urlBuilder = urlBuilder;
        this.resourceClass = resourceClass;
    }

    protected Object executeGet(String requestUrl, ResponseType responseType) {
        return this.execute(requestUrl, responseType, HttpMethod.GET, null);
    }

    protected Object executeDelete(String requestUrl) {
        return this.execute(requestUrl, ResponseType.NONE, HttpMethod.DELETE, null);
    }

    protected Object execute(String url, ResponseType responseType, HttpMethod method, String requestBody) {
        try {
            HttpAdapter httpAdapter = this.client.getHttpAdapter();
            HttpAdapterRequest request = httpAdapter.newRequest(url, method, requestBody);
            LOGGER.debug("requesting {} {}", (Object)method, (Object)url);
            if (requestBody != null) {
                LOGGER.debug("request body: {}", (Object)requestBody);
            }
            if (method == HttpMethod.POST || method == HttpMethod.PATCH) {
                request.header("Content-Type", "application/vnd.api+json; charset=utf-8");
            }
            request.header("Accept", "application/vnd.api+json");
            HttpAdapterResponse response = request.execute();
            if (!response.isSuccessful()) {
                throw this.handleError(response);
            }
            String body = response.body();
            LOGGER.debug("response body: {}", (Object)body);
            ObjectMapper objectMapper = this.client.getObjectMapper();
            if (responseType != ResponseType.NONE && Resource.class.equals(this.resourceClass)) {
                Document document = (Document)objectMapper.readValue(body, Document.class);
                return ClientStubBase.toResourceResponse(document, objectMapper);
            }
            if (responseType != ResponseType.NONE) {
                Document document = (Document)objectMapper.readValue(body, Document.class);
                ClientDocumentMapper documentMapper = this.client.getDocumentMapper();
                return documentMapper.fromDocument(document, responseType == ResponseType.RESOURCES);
            }
            return null;
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private static Object toResourceResponse(Document document, ObjectMapper objectMapper) {
        Object data = document.getData().get();
        if (data instanceof List) {
            DefaultResourceList list = new DefaultResourceList();
            list.addAll((Collection)((List)data));
            if (document.getMeta() != null) {
                list.setMeta((MetaInformation)new JsonMetaInformation((JsonNode)document.getMeta(), objectMapper));
            }
            if (document.getLinks() != null) {
                list.setLinks((LinksInformation)new JsonLinksInformation((JsonNode)document.getMeta(), objectMapper));
            }
            return list;
        }
        return data;
    }

    protected RuntimeException handleError(HttpAdapterResponse response) throws IOException {
        ExceptionMapperRegistry exceptionMapperRegistry;
        Optional mapper;
        ObjectMapper objectMapper;
        Document document;
        ErrorResponse errorResponse = null;
        String body = response.body();
        String contentType = response.getResponseHeader("Content-Type");
        if (body.length() > 0 && contentType != null && contentType.toLowerCase().contains("application/vnd.api+json") && (document = (Document)(objectMapper = this.client.getObjectMapper()).readValue(body, Document.class)).getErrors() != null && !document.getErrors().isEmpty()) {
            errorResponse = new ErrorResponse((Collection)document.getErrors(), response.code());
        }
        if (errorResponse == null) {
            errorResponse = new ErrorResponse(null, response.code());
        }
        if ((mapper = (exceptionMapperRegistry = this.client.getExceptionMapperRegistry()).findMapperFor(errorResponse)).isPresent()) {
            Throwable throwable = ((ExceptionMapper)mapper.get()).fromErrorResponse(errorResponse);
            if (throwable instanceof RuntimeException) {
                return (RuntimeException)throwable;
            }
            return new ClientException(response.code(), response.message(), throwable);
        }
        return new ClientException(response.code(), response.message());
    }

    public static enum ResponseType {
        NONE,
        RESOURCE,
        RESOURCES;

    }
}

