/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.internal;

import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceListBase;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.jodah.typetools.TypeResolver;

public class ClientStubInvocationHandler
implements InvocationHandler {
    private ResourceRepositoryV2<?, Serializable> repositoryStub;
    private Object actionStub;
    private Map<Method, Method> interfaceStubMethodMap = new HashMap<Method, Method>();

    public ClientStubInvocationHandler(Class<?> repositoryInterface, ResourceRepositoryV2<?, Serializable> repositoryStub, Object actionStub) {
        this.repositoryStub = repositoryStub;
        this.actionStub = actionStub;
        this.setupRepositoryMethods(repositoryInterface);
    }

    private static String getMethodId(Method method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getName());
        for (Class<?> paramType : method.getParameterTypes()) {
            builder.append("#");
            builder.append(paramType.getName());
        }
        return builder.toString();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getDeclaringClass().isAssignableFrom(ResourceRepositoryV2.class)) {
                return method.invoke(this.repositoryStub, args);
            }
            if (this.interfaceStubMethodMap.containsKey(method)) {
                return this.invokeInterfaceMethod(method, args);
            }
            PreconditionUtil.assertNotNull((String)"cannot execute method, no ActionStubFactory configured with CrnkClient", (Object)this.actionStub);
            return method.invoke(this.actionStub, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private Object invokeInterfaceMethod(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        Method stubMethod = this.interfaceStubMethodMap.get(method);
        Object result = stubMethod.invoke(this.repositoryStub, args);
        Class<?> returnType = method.getReturnType();
        if (result == null || returnType.isInstance(result)) {
            return result;
        }
        if (result instanceof DefaultResourceList) {
            return this.createTypesafeList(result, returnType);
        }
        throw new IllegalStateException("cannot cast return type " + result + " to " + returnType.getName());
    }

    private Object createTypesafeList(Object result, Class<?> returnType) {
        DefaultResourceList defaultList = (DefaultResourceList)result;
        Class[] typeArguments = TypeResolver.resolveRawArguments(ResourceListBase.class, returnType);
        Class metaType = typeArguments[1];
        Class linksType = typeArguments[2];
        ResourceListBase typedList = (ResourceListBase)ClassUtils.newInstance(returnType);
        typedList.addAll((Collection)defaultList);
        typedList.setMeta(defaultList.getMeta(metaType));
        typedList.setLinks(defaultList.getLinks(linksType));
        return typedList;
    }

    private void setupRepositoryMethods(Class<?> repositoryInterface) {
        HashMap<String, Method> stubMethods = new HashMap<String, Method>();
        for (Method method : ResourceRepositoryV2.class.getMethods()) {
            stubMethods.put(ClientStubInvocationHandler.getMethodId(method), method);
        }
        for (Method method : repositoryInterface.getDeclaredMethods()) {
            String id = ClientStubInvocationHandler.getMethodId(method);
            Method stubMethod = (Method)stubMethods.get(id);
            if (stubMethod == null) continue;
            this.interfaceStubMethodMap.put(method, stubMethod);
        }
    }
}

