/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.client.CrnkClient;
import io.crnk.client.internal.ClientStubBase;
import io.crnk.client.legacy.RelationshipRepositoryStub;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.JsonApiUrlBuilder;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.RelationshipRepositoryV2;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.utils.Nullable;
import io.crnk.legacy.queryParams.QueryParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.Callable;

public class RelationshipRepositoryStubImpl<T, I extends Serializable, D, J extends Serializable>
extends ClientStubBase
implements RelationshipRepositoryStub<T, I, D, J>,
RelationshipRepositoryV2<T, I, D, J> {
    private Class<T> sourceClass;
    private Class<D> targetClass;
    private ResourceInformation sourceResourceInformation;

    public RelationshipRepositoryStubImpl(CrnkClient client, Class<T> sourceClass, Class<D> targetClass, ResourceInformation sourceResourceInformation, JsonApiUrlBuilder urlBuilder) {
        super(client, urlBuilder, targetClass);
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.sourceResourceInformation = sourceResourceInformation;
    }

    public void setRelation(T source, J targetId, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithId(url, HttpMethod.PATCH, targetId);
    }

    public void setRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithIds(url, HttpMethod.PATCH, targetIds);
    }

    public void addRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithIds(url, HttpMethod.POST, targetIds);
    }

    public void removeRelations(T source, Iterable<J> targetIds, String fieldName) {
        Serializable sourceId = this.getSourceId(source);
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, (Object)sourceId, (QuerySpec)null, fieldName);
        this.executeWithIds(url, HttpMethod.DELETE, targetIds);
    }

    private Serializable getSourceId(T source) {
        if (source instanceof Resource) {
            return ((Resource)source).getId();
        }
        ResourceField idField = this.sourceResourceInformation.getIdField();
        return (Serializable)idField.getAccessor().getValue(source);
    }

    public D findOneTarget(I sourceId, String fieldName, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, queryParams, fieldName);
        return (D)this.executeGet(url, ClientStubBase.ResponseType.RESOURCE);
    }

    @Override
    public DefaultResourceList<D> findManyTargets(I sourceId, String fieldName, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, queryParams, fieldName);
        return (DefaultResourceList)this.executeGet(url, ClientStubBase.ResponseType.RESOURCES);
    }

    public D findOneTarget(I sourceId, String fieldName, QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, querySpec, fieldName);
        return (D)this.executeGet(url, ClientStubBase.ResponseType.RESOURCE);
    }

    public DefaultResourceList<D> findManyTargets(I sourceId, String fieldName, QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.sourceResourceInformation, sourceId, querySpec, fieldName);
        return (DefaultResourceList)this.executeGet(url, ClientStubBase.ResponseType.RESOURCES);
    }

    private void executeWithIds(String requestUrl, HttpMethod method, Iterable<?> targetIds) {
        Document document = new Document();
        ArrayList<ResourceIdentifier> resourceIdentifiers = new ArrayList<ResourceIdentifier>();
        for (Object targetId : targetIds) {
            String strTargetId = this.sourceResourceInformation.toIdString(targetId);
            resourceIdentifiers.add(new ResourceIdentifier(strTargetId, this.sourceResourceInformation.getResourceType()));
        }
        document.setData(Nullable.of(resourceIdentifiers));
        this.doExecute(requestUrl, method, document);
    }

    private void executeWithId(String requestUrl, HttpMethod method, Object targetIds) {
        Document document = new Document();
        String strTargetId = this.sourceResourceInformation.toIdString(targetIds);
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(strTargetId, this.sourceResourceInformation.getResourceType());
        document.setData(Nullable.of((Object)resourceIdentifier));
        this.doExecute(requestUrl, method, document);
    }

    private void doExecute(String requestUrl, HttpMethod method, final Document document) {
        final ObjectMapper objectMapper = this.client.getObjectMapper();
        String requestBodyValue = (String)ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return objectMapper.writeValueAsString((Object)document);
            }
        });
        this.execute(requestUrl, ClientStubBase.ResponseType.NONE, method, requestBodyValue);
    }

    public Class<T> getSourceResourceClass() {
        return this.sourceClass;
    }

    public Class<D> getTargetResourceClass() {
        return this.targetClass;
    }
}

