/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.client.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.client.CrnkClient;
import io.crnk.client.internal.ClientDocumentMapper;
import io.crnk.client.internal.ClientStubBase;
import io.crnk.client.legacy.ResourceRepositoryStub;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.JsonApiUrlBuilder;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.ResourceRepositoryV2;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.legacy.queryParams.QueryParams;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;

public class ResourceRepositoryStubImpl<T, I extends Serializable>
extends ClientStubBase
implements ResourceRepositoryV2<T, I>,
ResourceRepositoryStub<T, I> {
    private ResourceInformation resourceInformation;

    public ResourceRepositoryStubImpl(CrnkClient client, Class<T> resourceClass, ResourceInformation resourceInformation, JsonApiUrlBuilder urlBuilder) {
        super(client, urlBuilder, resourceClass);
        this.resourceInformation = resourceInformation;
    }

    private Object executeUpdate(String requestUrl, T resource, boolean create) {
        JsonApiResponse response = new JsonApiResponse();
        response.setEntity(resource);
        ClientDocumentMapper documentMapper = this.client.getDocumentMapper();
        final Document requestDocument = documentMapper.toDocument(response, null);
        final ObjectMapper objectMapper = this.client.getObjectMapper();
        String requestBodyValue = (String)ExceptionUtil.wrapCatchedExceptions((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return objectMapper.writeValueAsString((Object)requestDocument);
            }
        });
        HttpMethod method = create || this.client.getPushAlways() ? HttpMethod.POST : HttpMethod.PATCH;
        return this.execute(requestUrl, ClientStubBase.ResponseType.RESOURCE, method, requestBodyValue);
    }

    public T findOne(I id, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, queryParams);
        return this.findOne(url);
    }

    @Override
    public List<T> findAll(QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, null, queryParams);
        return this.findAll(url);
    }

    @Override
    public List<T> findAll(Iterable<I> ids, QueryParams queryParams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, ids, queryParams);
        return this.findAll(url);
    }

    public <S extends T> S save(S entity) {
        return this.modify(entity, false);
    }

    private <S extends T> S modify(S entity, boolean create) {
        Object id = this.getId(entity, create);
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, (QuerySpec)null);
        return (S)this.executeUpdate(url, entity, create);
    }

    @Override
    public <S extends T> S create(S entity) {
        return this.modify(entity, true);
    }

    private <S extends T> Object getId(S entity, boolean create) {
        if (this.client.getPushAlways()) {
            return null;
        }
        if (create) {
            return null;
        }
        if (entity instanceof Resource) {
            return ((Resource)entity).getId();
        }
        ResourceField idField = this.resourceInformation.getIdField();
        return idField.getAccessor().getValue(entity);
    }

    public void delete(I id) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, (QuerySpec)null);
        this.executeDelete(url);
    }

    public Class<T> getResourceClass() {
        return this.resourceClass;
    }

    public T findOne(I id, QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, id, querySpec);
        return this.findOne(url);
    }

    public DefaultResourceList<T> findAll(QuerySpec querySpec) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, null, querySpec);
        return this.findAll(url);
    }

    public DefaultResourceList<T> findAll(Iterable<I> ids, QuerySpec queryPaquerySpecrams) {
        String url = this.urlBuilder.buildUrl(this.resourceInformation, ids, queryPaquerySpecrams);
        return this.findAll(url);
    }

    public DefaultResourceList<T> findAll(String url) {
        return (DefaultResourceList)this.executeGet(url, ClientStubBase.ResponseType.RESOURCES);
    }

    private T findOne(String url) {
        return (T)this.executeGet(url, ClientStubBase.ResponseType.RESOURCE);
    }
}

