/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.boot.autoconfigure;

import io.crnk.core.engine.transaction.TransactionRunner;
import io.crnk.jpa.JpaModule;
import io.crnk.jpa.query.JpaQueryFactory;
import io.crnk.jpa.query.criteria.JpaCriteriaQueryFactory;
import io.crnk.jpa.query.querydsl.QuerydslQueryFactory;
import io.crnk.spring.boot.CrnkJpaProperties;
import io.crnk.spring.boot.CrnkSpringBootProperties;
import io.crnk.spring.boot.v3.CrnkConfigV3;
import io.crnk.spring.jpa.SpringTransactionRunner;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="crnk.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={JpaModule.class})
@ConditionalOnMissingBean(value={JpaModule.class})
@EnableConfigurationProperties(value={CrnkJpaProperties.class, CrnkSpringBootProperties.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@AutoConfigureBefore
@Import(value={CrnkConfigV3.class})
public class CrnkJpaAutoConfiguration {
    @Autowired
    private EntityManager em;
    @Autowired
    private EntityManagerFactory emf;
    @Autowired
    private CrnkJpaProperties jpaProperties;

    @Bean
    public SpringTransactionRunner transactionRunner() {
        return new SpringTransactionRunner();
    }

    @Bean
    public JpaModule jpaModule() {
        JpaModule module = JpaModule.newServerModule((EntityManagerFactory)this.emf, (EntityManager)this.em, (TransactionRunner)this.transactionRunner());
        if (this.jpaProperties.getQueryFactory() != null) {
            switch (this.jpaProperties.getQueryFactory()) {
                case CRITERIA: {
                    module.setQueryFactory((JpaQueryFactory)JpaCriteriaQueryFactory.newInstance());
                    break;
                }
                case QUERYDSL: {
                    module.setQueryFactory((JpaQueryFactory)QuerydslQueryFactory.newInstance());
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown query factory");
                }
            }
        }
        return module;
    }
}

