/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.boot.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.spring.SpringCrnkFilter;
import io.crnk.spring.boot.CrnkSpringBootProperties;
import io.crnk.spring.internal.SpringServiceDiscovery;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CrnkSpringBootProperties.class})
public class CrnkConfigV3
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private CrnkSpringBootProperties properties;
    private ObjectMapper objectMapper;

    @Autowired
    public CrnkConfigV3(CrnkSpringBootProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }

    @Bean
    public SpringServiceDiscovery discovery() {
        return new SpringServiceDiscovery();
    }

    @Bean
    public CrnkBoot crnkBoot(SpringServiceDiscovery serviceDiscovery) {
        CrnkBoot boot = new CrnkBoot();
        boot.setObjectMapper(this.objectMapper);
        if (this.properties.getDomainName() != null && this.properties.getPathPrefix() != null) {
            String baseUrl = this.properties.getDomainName() + this.properties.getPathPrefix();
            boot.setServiceUrlProvider((ServiceUrlProvider)new ConstantServiceUrlProvider(baseUrl));
        }
        boot.setServiceDiscovery((ServiceDiscovery)serviceDiscovery);
        boot.setDefaultPageLimit(this.properties.getDefaultPageLimit());
        boot.setMaxPageLimit(this.properties.getMaxPageLimit());
        boot.setPropertiesProvider(new PropertiesProvider(){

            public String getProperty(String key) {
                if ("crnk.config.core.resource.package".equals(key)) {
                    return CrnkConfigV3.this.properties.getResourcePackage();
                }
                if ("crnk.config.core.resource.domain".equals(key)) {
                    return CrnkConfigV3.this.properties.getDomainName();
                }
                if ("crnk.config.web.path.prefix".equals(key)) {
                    return CrnkConfigV3.this.properties.getPathPrefix();
                }
                if ("crnk.config.resource.request.allowUnknownAttributes".equals(key)) {
                    return String.valueOf(CrnkConfigV3.this.properties.getAllowUnknownAttributes());
                }
                if ("crnk.config.resource.response.return_404".equals(key)) {
                    return String.valueOf(CrnkConfigV3.this.properties.getReturn404OnNull());
                }
                return CrnkConfigV3.this.applicationContext.getEnvironment().getProperty(key);
            }
        });
        boot.setAllowUnknownAttributes();
        boot.boot();
        return boot;
    }

    @Bean
    public Filter springBootSampleCrnkFilter(CrnkBoot boot) {
        return new SpringCrnkFilter(boot);
    }

    @Bean
    public ResourceRegistry resourceRegistry(CrnkBoot boot) {
        return boot.getResourceRegistry();
    }

    @Bean
    public ModuleRegistry moduleRegistry(CrnkBoot boot) {
        return boot.getModuleRegistry();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

