/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.jpa;

import io.crnk.core.engine.transaction.TransactionRunner;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionRunner
implements TransactionRunner {
    @Autowired
    private PlatformTransactionManager platformTransactionManager;

    public <T> T doInTransaction(final Callable<T> callable) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(0);
        TransactionTemplate template = new TransactionTemplate(this.platformTransactionManager, (TransactionDefinition)definition);
        try {
            return (T)template.execute(new TransactionCallback<T>(){

                public T doInTransaction(TransactionStatus status) {
                    try {
                        Object result = callable.call();
                        if (status.isRollbackOnly()) {
                            throw new RollbackOnlyException(result);
                        }
                        return result;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        }
        catch (RollbackOnlyException e) {
            return (T)e.getResult();
        }
    }

    class RollbackOnlyException
    extends RuntimeException {
        private transient Object result;

        public RollbackOnlyException(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

