/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.AnsiEscapes;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.NiceAppendable;
import java.util.HashMap;
import java.util.Map;

class ProgressFormatter
implements Formatter,
ColorAware {
    private static final Map<Result.Type, Character> CHARS = new HashMap<Result.Type, Character>(){
        {
            this.put(Result.Type.PASSED, Character.valueOf('.'));
            this.put(Result.Type.UNDEFINED, Character.valueOf('U'));
            this.put(Result.Type.PENDING, Character.valueOf('P'));
            this.put(Result.Type.SKIPPED, Character.valueOf('-'));
            this.put(Result.Type.FAILED, Character.valueOf('F'));
            this.put(Result.Type.AMBIGUOUS, Character.valueOf('A'));
        }
    };
    private static final Map<Result.Type, AnsiEscapes> ANSI_ESCAPES = new HashMap<Result.Type, AnsiEscapes>(){
        {
            this.put(Result.Type.PASSED, AnsiEscapes.GREEN);
            this.put(Result.Type.UNDEFINED, AnsiEscapes.YELLOW);
            this.put(Result.Type.PENDING, AnsiEscapes.YELLOW);
            this.put(Result.Type.SKIPPED, AnsiEscapes.CYAN);
            this.put(Result.Type.FAILED, AnsiEscapes.RED);
            this.put(Result.Type.AMBIGUOUS, AnsiEscapes.RED);
        }
    };
    private final NiceAppendable out;
    private boolean monochrome = false;
    private EventHandler<TestStepFinished> stepFinishedhandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            ProgressFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<WriteEvent> writeHandler = new EventHandler<WriteEvent>(){

        @Override
        public void receive(WriteEvent event) {
            ProgressFormatter.this.handleWrite(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            ProgressFormatter.this.handleTestRunFinished();
        }
    };

    public ProgressFormatter(Appendable appendable) {
        this.out = new NiceAppendable(appendable);
    }

    @Override
    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedhandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishHandler);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (!event.testStep.isHook() || event.result.is(Result.Type.FAILED)) {
            if (!this.monochrome) {
                ANSI_ESCAPES.get((Object)event.result.getStatus()).appendTo(this.out);
            }
            this.out.append(CHARS.get((Object)event.result.getStatus()).charValue());
            if (!this.monochrome) {
                AnsiEscapes.RESET.appendTo(this.out);
            }
        }
    }

    private void handleWrite(WriteEvent event) {
        this.out.append(event.text);
    }

    private void handleTestRunFinished() {
        this.out.println();
        this.out.close();
    }
}

