/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.NiceAppendable;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UsageFormatter
implements Formatter {
    private static final BigDecimal NANOS_PER_SECOND = BigDecimal.valueOf(1000000000L);
    final Map<String, List<StepContainer>> usageMap = new HashMap<String, List<StepContainer>>();
    private final Map<String, UsageStatisticStrategy> statisticStrategies = new HashMap<String, UsageStatisticStrategy>();
    private final NiceAppendable out;
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            UsageFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            UsageFormatter.this.finishReport();
        }
    };

    public UsageFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
        this.addUsageStatisticStrategy("median", new MedianUsageStatisticStrategy());
        this.addUsageStatisticStrategy("average", new AverageUsageStatisticStrategy());
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    void handleTestStepFinished(TestStepFinished event) {
        if (!event.testStep.isHook() && event.result.is(Result.Type.PASSED)) {
            this.addUsageEntry(event.result, event.testStep.getPattern(), event.testStep.getStepText(), event.testStep.getStepLocation());
        }
    }

    void finishReport() {
        ArrayList<StepDefContainer> stepDefContainers = new ArrayList<StepDefContainer>();
        for (Map.Entry<String, List<StepContainer>> usageEntry : this.usageMap.entrySet()) {
            StepDefContainer stepDefContainer = new StepDefContainer();
            stepDefContainers.add(stepDefContainer);
            stepDefContainer.source = usageEntry.getKey();
            stepDefContainer.steps = this.createStepContainer(usageEntry.getValue());
        }
        this.out.append(this.gson().toJson(stepDefContainers));
        this.out.close();
    }

    private List<StepContainer> createStepContainer(List<StepContainer> stepContainers) {
        for (StepContainer stepContainer : stepContainers) {
            stepContainer.aggregatedDurations = this.createAggregatedDurations(stepContainer);
            this.formatDurationAsSeconds(stepContainer.durations);
        }
        return stepContainers;
    }

    private void formatDurationAsSeconds(List<StepDuration> durations) {
        for (StepDuration duration : durations) {
            duration.duration = this.toSeconds(duration.duration.longValue());
        }
    }

    private Map<String, BigDecimal> createAggregatedDurations(StepContainer stepContainer) {
        HashMap<String, BigDecimal> aggregatedResults = new HashMap<String, BigDecimal>();
        for (Map.Entry<String, UsageStatisticStrategy> calculatorEntry : this.statisticStrategies.entrySet()) {
            UsageStatisticStrategy statisticStrategy = calculatorEntry.getValue();
            List<Long> rawDurations = this.getRawDurations(stepContainer.durations);
            Long calculationResult = statisticStrategy.calculate(rawDurations);
            String strategy = calculatorEntry.getKey();
            aggregatedResults.put(strategy, this.toSeconds(calculationResult));
        }
        return aggregatedResults;
    }

    private BigDecimal toSeconds(Long nanoSeconds) {
        return BigDecimal.valueOf(nanoSeconds).divide(NANOS_PER_SECOND);
    }

    private List<Long> getRawDurations(List<StepDuration> stepDurations) {
        ArrayList<Long> rawDurations = new ArrayList<Long>();
        for (StepDuration stepDuration : stepDurations) {
            rawDurations.add(stepDuration.duration.longValue());
        }
        return rawDurations;
    }

    private Gson gson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    private void addUsageEntry(Result result, String stepDefinition, String stepNameWithArgs, String stepLocation) {
        List<StepContainer> stepContainers = this.usageMap.get(stepDefinition);
        if (stepContainers == null) {
            stepContainers = new ArrayList<StepContainer>();
            this.usageMap.put(stepDefinition, stepContainers);
        }
        StepContainer stepContainer = this.findOrCreateStepContainer(stepNameWithArgs, stepContainers);
        Long duration = result.getDuration();
        StepDuration stepDuration = this.createStepDuration(duration, stepLocation);
        stepContainer.durations.add(stepDuration);
    }

    private StepDuration createStepDuration(Long duration, String location) {
        StepDuration stepDuration = new StepDuration();
        stepDuration.duration = duration == null ? BigDecimal.ZERO : BigDecimal.valueOf(duration);
        stepDuration.location = location;
        return stepDuration;
    }

    private StepContainer findOrCreateStepContainer(String stepNameWithArgs, List<StepContainer> stepContainers) {
        for (StepContainer container : stepContainers) {
            if (!stepNameWithArgs.equals(container.name)) continue;
            return container;
        }
        StepContainer stepContainer = new StepContainer();
        stepContainer.name = stepNameWithArgs;
        stepContainers.add(stepContainer);
        return stepContainer;
    }

    public void addUsageStatisticStrategy(String key, UsageStatisticStrategy strategy) {
        this.statisticStrategies.put(key, strategy);
    }

    static class MedianUsageStatisticStrategy
    implements UsageStatisticStrategy {
        MedianUsageStatisticStrategy() {
        }

        @Override
        public Long calculate(List<Long> durationEntries) {
            if (this.verifyNoNulls(durationEntries)) {
                return 0L;
            }
            Collections.sort(durationEntries);
            int middle = durationEntries.size() / 2;
            if (durationEntries.size() % 2 == 1) {
                return durationEntries.get(middle);
            }
            return (durationEntries.get(middle - 1) + durationEntries.get(middle)) / 2L;
        }

        private boolean verifyNoNulls(List<Long> durationEntries) {
            return durationEntries == null || durationEntries.isEmpty() || durationEntries.contains(null);
        }
    }

    static class AverageUsageStatisticStrategy
    implements UsageStatisticStrategy {
        AverageUsageStatisticStrategy() {
        }

        @Override
        public Long calculate(List<Long> durationEntries) {
            if (this.verifyNoNulls(durationEntries)) {
                return 0L;
            }
            long sum = 0L;
            for (Long duration : durationEntries) {
                sum += duration.longValue();
            }
            return sum / (long)durationEntries.size();
        }

        private boolean verifyNoNulls(List<Long> durationEntries) {
            return durationEntries == null || durationEntries.isEmpty() || durationEntries.contains(null);
        }
    }

    static interface UsageStatisticStrategy {
        public Long calculate(List<Long> var1);
    }

    static class StepDuration {
        public BigDecimal duration;
        public String location;

        StepDuration() {
        }
    }

    static class StepContainer {
        public String name;
        public Map<String, BigDecimal> aggregatedDurations = new HashMap<String, BigDecimal>();
        public List<StepDuration> durations = new ArrayList<StepDuration>();

        StepContainer() {
        }
    }

    static class StepDefContainer {
        public String source;
        public List<StepContainer> steps;

        StepDefContainer() {
        }
    }
}

