/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.formatter.StrictAware;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.runtime.formatter.URLOutputStream;
import cucumber.runtime.formatter.UTF8OutputStreamWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class JUnitFormatter
implements EventListener,
StrictAware {
    private final Writer out;
    private final Document doc;
    private final Element rootElement;
    private TestCase testCase;
    private Element root;
    private EventHandler<TestSourceRead> sourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            JUnitFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            JUnitFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            JUnitFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<TestCaseFinished> caseFinishedHandler = new EventHandler<TestCaseFinished>(){

        @Override
        public void receive(TestCaseFinished event) {
            JUnitFormatter.this.handleTestCaseFinished(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            JUnitFormatter.this.finishReport();
        }
    };

    public JUnitFormatter(URL out) throws IOException {
        this.out = new UTF8OutputStreamWriter(new URLOutputStream(out));
        TestCase.treatConditionallySkippedAsFailure = false;
        TestCase.currentFeatureFile = null;
        TestCase.previousTestCaseName = "";
        TestCase.exampleNumber = 1;
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.rootElement = this.doc.createElement("testsuite");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error while processing unit report", e);
        }
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.sourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        TestCase.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (TestCase.currentFeatureFile == null || !TestCase.currentFeatureFile.equals(event.testCase.getUri())) {
            TestCase.currentFeatureFile = event.testCase.getUri();
            TestCase.previousTestCaseName = "";
            TestCase.exampleNumber = 1;
        }
        this.testCase = new TestCase(event.testCase);
        this.root = this.testCase.createElement(this.doc);
        this.testCase.writeElement(this.doc, this.root);
        this.rootElement.appendChild(this.root);
        this.increaseAttributeValue(this.rootElement, "tests");
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleStepTestStep) {
            this.testCase.steps.add((PickleStepTestStep)event.testStep);
            this.testCase.results.add(event.result);
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (this.testCase.steps.isEmpty()) {
            this.testCase.handleEmptyTestCase(this.doc, this.root, event.result);
        } else {
            this.testCase.addTestCaseElement(this.doc, this.root, event.result);
        }
    }

    private void finishReport() {
        try {
            this.rootElement.setAttribute("name", JUnitFormatter.class.getName());
            this.rootElement.setAttribute("failures", String.valueOf(this.rootElement.getElementsByTagName("failure").getLength()));
            this.rootElement.setAttribute("skipped", String.valueOf(this.rootElement.getElementsByTagName("skipped").getLength()));
            this.rootElement.setAttribute("time", this.sumTimes(this.rootElement.getElementsByTagName("testcase")));
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(this.out);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
            JUnitFormatter.closeQuietly(this.out);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error while transforming.", e);
        }
    }

    private String sumTimes(NodeList testCaseNodes) {
        double totalDurationSecondsForAllTimes = 0.0;
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            try {
                double testCaseTime = Double.parseDouble(testCaseNodes.item(i).getAttributes().getNamedItem("time").getNodeValue());
                totalDurationSecondsForAllTimes += testCaseTime;
                continue;
            }
            catch (NumberFormatException e) {
                throw new CucumberException(e);
            }
            catch (NullPointerException e) {
                throw new CucumberException(e);
            }
        }
        DecimalFormat nfmt = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        nfmt.applyPattern("0.######");
        return nfmt.format(totalDurationSecondsForAllTimes);
    }

    private void increaseAttributeValue(Element element, String attribute) {
        int value = 0;
        if (element.hasAttribute(attribute)) {
            value = Integer.parseInt(element.getAttribute(attribute));
        }
        element.setAttribute(attribute, String.valueOf(++value));
    }

    @Override
    public void setStrict(boolean strict) {
        TestCase.treatConditionallySkippedAsFailure = strict;
    }

    private static void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class TestCase {
        private static final DecimalFormat NUMBER_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        private static final TestSourcesModel testSources = new TestSourcesModel();
        static String currentFeatureFile;
        static String previousTestCaseName;
        static int exampleNumber;
        static boolean treatConditionallySkippedAsFailure;
        final List<PickleStepTestStep> steps = new ArrayList<PickleStepTestStep>();
        final List<Result> results = new ArrayList<Result>();
        private final cucumber.api.TestCase testCase;

        private TestCase(cucumber.api.TestCase testCase) {
            this.testCase = testCase;
        }

        private Element createElement(Document doc) {
            return doc.createElement("testcase");
        }

        private void writeElement(Document doc, Element tc) {
            tc.setAttribute("classname", testSources.getFeatureName(currentFeatureFile));
            tc.setAttribute("name", this.calculateElementName(this.testCase));
        }

        private String calculateElementName(cucumber.api.TestCase testCase) {
            String testCaseName = testCase.getName();
            if (testCaseName.equals(previousTestCaseName)) {
                return Utils.getUniqueTestNameForScenarioExample(testCaseName, ++exampleNumber);
            }
            previousTestCaseName = testCase.getName();
            exampleNumber = 1;
            return testCaseName;
        }

        public void addTestCaseElement(Document doc, Element tc, Result result) {
            Element child;
            tc.setAttribute("time", this.calculateTotalDurationString(result));
            StringBuilder sb = new StringBuilder();
            this.addStepAndResultListing(sb);
            if (result.is(Result.Type.FAILED)) {
                this.addStackTrace(sb, result);
                child = this.createElementWithMessage(doc, sb, "failure", result.getErrorMessage());
            } else if (result.is(Result.Type.AMBIGUOUS)) {
                this.addStackTrace(sb, result);
                child = this.createElementWithMessage(doc, sb, "failure", result.getErrorMessage());
            } else if (result.is(Result.Type.PENDING) || result.is(Result.Type.UNDEFINED)) {
                child = treatConditionallySkippedAsFailure ? this.createElementWithMessage(doc, sb, "failure", "The scenario has pending or undefined step(s)") : this.createElement(doc, sb, "skipped");
            } else if (result.is(Result.Type.SKIPPED) && result.getError() != null) {
                this.addStackTrace(sb, result);
                child = this.createElementWithMessage(doc, sb, "skipped", result.getErrorMessage());
            } else {
                child = this.createElement(doc, sb, "system-out");
            }
            tc.appendChild(child);
        }

        public void handleEmptyTestCase(Document doc, Element tc, Result result) {
            tc.setAttribute("time", this.calculateTotalDurationString(result));
            String resultType = treatConditionallySkippedAsFailure ? "failure" : "skipped";
            Element child = this.createElementWithMessage(doc, new StringBuilder(), resultType, "The scenario has no steps");
            tc.appendChild(child);
        }

        private String calculateTotalDurationString(Result result) {
            return NUMBER_FORMAT.format((double)result.getDuration().longValue() / 1.0E9);
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.steps.size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.results.size()) {
                    resultStatus = this.results.get(i).getStatus().lowerCaseName();
                }
                sb.append(this.getKeywordFromSource(this.steps.get(i).getStepLine()) + this.steps.get(i).getStepText());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private String getKeywordFromSource(int stepLine) {
            return testSources.getKeywordFromSource(currentFeatureFile, stepLine);
        }

        private void addStackTrace(StringBuilder sb, Result failed) {
            sb.append("\nStackTrace:\n");
            StringWriter sw = new StringWriter();
            failed.getError().printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
        }

        private Element createElementWithMessage(Document doc, StringBuilder sb, String elementType, String message) {
            Element child = this.createElement(doc, sb, elementType);
            child.setAttribute("message", message);
            return child;
        }

        private Element createElement(Document doc, StringBuilder sb, String elementType) {
            Element child = doc.createElement(elementType);
            child.appendChild(doc.createCDATASection(sb.toString().replace(System.lineSeparator(), "\n")));
            return child;
        }

        static {
            NUMBER_FORMAT.applyPattern("0.######");
            treatConditionallySkippedAsFailure = false;
        }
    }
}

