/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.ClasspathResourceLoader;
import cucumber.runtime.io.FileResourceLoader;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class MultiLoader
implements ResourceLoader {
    static final String CLASSPATH_SCHEME = "classpath";
    public static final String CLASSPATH_SCHEME_PREFIX = "classpath:";
    static final String FILE_SCHEME = "file";
    public static final String FILE_SCHEME_PREFIX = "file:";
    private final ClasspathResourceLoader classpath;
    private final FileResourceLoader fs;

    public MultiLoader(ClassLoader classLoader) {
        this.classpath = new ClasspathResourceLoader(classLoader);
        this.fs = new FileResourceLoader();
    }

    @Override
    public Iterable<Resource> resources(URI path, String suffix) {
        if (CLASSPATH_SCHEME.equals(path.getScheme())) {
            return this.classpath.resources(path, suffix);
        }
        if (FILE_SCHEME.equals(path.getScheme())) {
            return this.fs.resources(path, suffix);
        }
        throw new IllegalArgumentException("Unsupported scheme: " + path);
    }

    public static List<String> packageName(List<URI> glue) {
        ArrayList<String> packageNames = new ArrayList<String>(glue.size());
        for (URI gluePath : glue) {
            if (!CLASSPATH_SCHEME.equals(gluePath.getScheme())) continue;
            packageNames.add(MultiLoader.packageName(gluePath.getSchemeSpecificPart()));
        }
        return packageNames;
    }

    private static String packageName(String gluePath) {
        if (MultiLoader.isClasspathPath(gluePath)) {
            gluePath = MultiLoader.stripClasspathPrefix(gluePath);
        }
        if (gluePath.startsWith("/")) {
            gluePath = gluePath.substring(1);
        }
        return gluePath.replace('/', '.');
    }

    private static boolean isClasspathPath(String path) {
        return path.startsWith(CLASSPATH_SCHEME_PREFIX);
    }

    private static String stripClasspathPrefix(String path) {
        return path.substring(CLASSPATH_SCHEME_PREFIX.length());
    }
}

