/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testng;

import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.runner.EventBus;
import cucumber.runner.Runner;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.events.PickleEvent;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.EnvironmentOptionsParser;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import io.cucumber.core.options.RunnerOptions;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.testng.CucumberExceptionWrapper;
import io.cucumber.testng.CucumberFeatureWrapperImpl;
import io.cucumber.testng.PickleEventWrapperImpl;
import io.cucumber.testng.TestCaseResultListener;
import io.cucumber.testng.TestNGCucumberOptionsProvider;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class TestNGCucumberRunner {
    private final EventBus bus;
    private final Filters filters;
    private final FeaturePathFeatureSupplier featureSupplier;
    private final ThreadLocalRunnerSupplier runnerSupplier;
    private final RuntimeOptions runtimeOptions;
    private final Plugins plugins;

    public TestNGCucumberRunner(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        RuntimeOptions annotationOptions = new CucumberOptionsAnnotationParser((ResourceLoader)resourceLoader).withOptionsProvider((CucumberOptionsAnnotationParser.OptionsProvider)new TestNGCucumberOptionsProvider()).parse(clazz).build();
        this.runtimeOptions = new EnvironmentOptionsParser((ResourceLoader)resourceLoader).parse(Env.INSTANCE).build(annotationOptions);
        this.runtimeOptions.addUndefinedStepsPrinterIfSummaryNotDefined();
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier((ResourceLoader)resourceLoader, (ClassFinder)classFinder, (RunnerOptions)this.runtimeOptions);
        this.bus = new TimeServiceEventBus(TimeService.SYSTEM);
        this.plugins = new Plugins(classLoader, new PluginFactory(), (PluginOptions)this.runtimeOptions);
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        this.filters = new Filters((FilterOptions)this.runtimeOptions);
        this.runnerSupplier = new ThreadLocalRunnerSupplier((RunnerOptions)this.runtimeOptions, this.bus, (BackendSupplier)backendSupplier);
        this.featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)this.runtimeOptions);
    }

    public void runScenario(PickleEvent pickle) throws Throwable {
        Runner runner = this.runnerSupplier.get();
        TestCaseResultListener testCaseResultListener = new TestCaseResultListener(runner.getBus(), this.runtimeOptions.isStrict());
        runner.runPickle(pickle);
        testCaseResultListener.finishExecutionUnit();
        if (!testCaseResultListener.isPassed()) {
            throw testCaseResultListener.getError();
        }
    }

    public void finish() {
        this.bus.send((Event)new TestRunFinished(this.bus.getTime(), this.bus.getTimeMillis().longValue()));
    }

    public Object[][] provideScenarios() {
        try {
            ArrayList<Object[]> scenarios = new ArrayList<Object[]>();
            List<CucumberFeature> features = this.getFeatures();
            for (CucumberFeature feature : features) {
                for (PickleEvent pickle : feature.getPickles()) {
                    if (!this.filters.matchesFilters(pickle)) continue;
                    scenarios.add(new Object[]{new PickleEventWrapperImpl(pickle), new CucumberFeatureWrapperImpl(feature)});
                }
            }
            return (Object[][])scenarios.toArray((T[])new Object[0][]);
        }
        catch (CucumberException e) {
            return new Object[][]{{new CucumberExceptionWrapper(e), null}};
        }
    }

    private List<CucumberFeature> getFeatures() {
        this.plugins.setSerialEventBusOnEventListenerPlugins((EventPublisher)this.bus);
        List features = this.featureSupplier.get();
        this.bus.send((Event)new TestRunStarted(this.bus.getTime(), this.bus.getTimeMillis().longValue()));
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead(this.bus);
        }
        return features;
    }
}

