/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.InsertField;
import org.apache.kafka.connect.transforms.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewRecordState<R extends ConnectRecord<R>>
implements Transformation<R> {
    private static final String ENVELOPE_SCHEMA_NAME_SUFFIX = ".Envelope";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewRecordState.class);
    private boolean dropTombstones;
    private ExtractNewRecordStateConfigDefinition.DeleteHandling handleDeletes;
    private boolean addOperationHeader;
    private final ExtractField<R> afterDelegate = new ExtractField.Value();
    private final ExtractField<R> beforeDelegate = new ExtractField.Value();
    private final InsertField<R> removedDelegate = new InsertField.Value();
    private final InsertField<R> updatedDelegate = new InsertField.Value();

    public void configure(Map<String, ?> configs) {
        Configuration config = Configuration.from(configs);
        Field.Set configFields = Field.setOf(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES);
        if (!config.validateAndRecord(configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.dropTombstones = config.getBoolean(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES);
        this.handleDeletes = ExtractNewRecordStateConfigDefinition.DeleteHandling.parse(config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_DELETES));
        this.addOperationHeader = config.getBoolean(ExtractNewRecordStateConfigDefinition.OPERATION_HEADER);
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("field", "before");
        this.beforeDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("field", "after");
        this.afterDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("static.field", "__deleted");
        delegateConfig.put("static.value", "true");
        this.removedDelegate.configure(delegateConfig);
        delegateConfig = new HashMap();
        delegateConfig.put("static.field", "__deleted");
        delegateConfig.put("static.value", "false");
        this.updatedDelegate.configure(delegateConfig);
    }

    public R apply(R record) {
        if (record.value() == null) {
            if (this.dropTombstones) {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", record.key());
                return null;
            }
            Envelope.Operation operation = Envelope.Operation.DELETE;
            if (this.addOperationHeader) {
                record.headers().addString("__debezium-operation", operation.toString());
            }
            return record;
        }
        if (this.addOperationHeader) {
            String operationString = ((Struct)record.value()).getString("op");
            Envelope.Operation operation = Envelope.Operation.forCode(operationString);
            if (operationString.isEmpty() || operation == null) {
                LOGGER.warn("Unknown operation thus unable to add the operation header into the message");
            } else {
                record.headers().addString("__debezium-operation", operation.code());
            }
        }
        if (record.valueSchema() == null || record.valueSchema().name() == null || !record.valueSchema().name().endsWith(ENVELOPE_SCHEMA_NAME_SUFFIX)) {
            LOGGER.warn("Expected Envelope for transformation, passing it unchanged");
            return record;
        }
        ConnectRecord newRecord = this.afterDelegate.apply(record);
        if (newRecord.value() == null) {
            switch (this.handleDeletes) {
                case DROP: {
                    LOGGER.trace("Delete message {} requested to be dropped", record.key());
                    return null;
                }
                case REWRITE: {
                    LOGGER.trace("Delete message {} requested to be rewritten", record.key());
                    ConnectRecord oldRecord = this.beforeDelegate.apply(record);
                    return (R)this.removedDelegate.apply(oldRecord);
                }
            }
            return (R)newRecord;
        }
        switch (this.handleDeletes) {
            case REWRITE: {
                LOGGER.trace("Insert/update message {} requested to be rewritten", record.key());
                return (R)this.updatedDelegate.apply(newRecord);
            }
        }
        return (R)newRecord;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        Field.group(config, null, ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES, ExtractNewRecordStateConfigDefinition.OPERATION_HEADER);
        return config;
    }

    public void close() {
        this.beforeDelegate.close();
        this.afterDelegate.close();
        this.removedDelegate.close();
        this.updatedDelegate.close();
    }
}

