/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded.async;

import io.debezium.embedded.async.AbstractRecordProcessor;
import io.debezium.embedded.async.ProcessingCallables;
import io.debezium.engine.DebeziumEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSmtBatchProcessor
extends AbstractRecordProcessor<SourceRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelSmtBatchProcessor.class);
    final DebeziumEngine.RecordCommitter committer;
    final DebeziumEngine.ChangeConsumer<SourceRecord> userHandler;

    ParallelSmtBatchProcessor(DebeziumEngine.RecordCommitter committer, DebeziumEngine.ChangeConsumer<SourceRecord> userHandler) {
        this.committer = committer;
        this.userHandler = userHandler;
    }

    @Override
    public void processRecords(List<SourceRecord> records) throws Exception {
        LOGGER.debug("Thread {} is submitting {} records for processing.", (Object)Thread.currentThread().getName(), (Object)records.size());
        ArrayList recordFutures = new ArrayList(records.size());
        records.stream().forEachOrdered(r -> recordFutures.add(this.recordService.submit(new ProcessingCallables.TransformRecord((SourceRecord)r, this.transformations))));
        LOGGER.trace("Thread {} is getting source records.", (Object)Thread.currentThread().getName());
        ArrayList<SourceRecord> transformedRecords = new ArrayList<SourceRecord>(recordFutures.size());
        for (Future f : recordFutures) {
            SourceRecord record = (SourceRecord)f.get();
            if (record == null) continue;
            transformedRecords.add(record);
        }
        LOGGER.trace("Calling user handler.");
        this.userHandler.handleBatch(transformedRecords, this.committer);
    }
}

