/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.jackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import io.dropwizard.jersey.errors.ErrorMessage;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonProcessingExceptionMapper.class);
    private final boolean showDetails;

    public JsonProcessingExceptionMapper() {
        this(false);
    }

    public JsonProcessingExceptionMapper(boolean showDetails) {
        this.showDetails = showDetails;
    }

    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException) {
            LOGGER.warn("Error generating JSON", (Throwable)exception);
            return Response.serverError().build();
        }
        String message = exception.getOriginalMessage();
        if (exception instanceof JsonMappingException && !(exception instanceof UnrecognizedPropertyException)) {
            LOGGER.error("Unable to serialize or deserialize the specific type", (Throwable)exception);
            return Response.serverError().build();
        }
        LOGGER.debug("Unable to process JSON", (Throwable)exception);
        ErrorMessage errorMessage = new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to process JSON", this.showDetails ? message : null);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorMessage).build();
    }
}

