/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.Configuration;
import io.dropwizard.cli.ConfiguredCommand;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.migrations.CloseableLiquibase;
import io.dropwizard.migrations.CloseableLiquibaseWithClassPathMigrationsFile;
import io.dropwizard.migrations.CloseableLiquibaseWithFileSystemMigrationsFile;
import io.dropwizard.setup.Bootstrap;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public abstract class AbstractLiquibaseCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private final DatabaseConfiguration<T> strategy;
    private final Class<T> configurationClass;
    private final String migrationsFileName;

    protected AbstractLiquibaseCommand(String name, String description, DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super(name, description);
        this.strategy = strategy;
        this.configurationClass = configurationClass;
        this.migrationsFileName = migrationsFileName;
    }

    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"--migrations"}).dest("migrations-file").help("the file containing the Liquibase migrations for the application");
        subparser.addArgument(new String[]{"--catalog"}).dest("catalog").help("Specify the database catalog (use database default if omitted)");
        subparser.addArgument(new String[]{"--schema"}).dest("schema").help("Specify the database schema (use database default if omitted)");
    }

    protected void run(Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        PooledDataSourceFactory dbConfig = this.strategy.getDataSourceFactory(configuration);
        dbConfig.asSingleConnectionPool();
        try (CloseableLiquibase liquibase = this.openLiquibase(dbConfig, namespace);){
            this.run(namespace, liquibase);
        }
        catch (ValidationFailedException e) {
            e.printDescriptiveError(System.err);
            throw e;
        }
    }

    private CloseableLiquibase openLiquibase(PooledDataSourceFactory dataSourceFactory, Namespace namespace) throws SQLException, LiquibaseException {
        ManagedDataSource dataSource = dataSourceFactory.build(new MetricRegistry(), "liquibase");
        String migrationsFile = namespace.getString("migrations-file");
        CloseableLiquibase liquibase = migrationsFile == null ? new CloseableLiquibaseWithClassPathMigrationsFile(dataSource, this.migrationsFileName){} : new CloseableLiquibaseWithFileSystemMigrationsFile(dataSource, migrationsFile);
        Database database = liquibase.getDatabase();
        String catalogName = namespace.getString("catalog");
        String schemaName = namespace.getString("schema");
        if (database.supportsCatalogs() && catalogName != null) {
            database.setDefaultCatalogName(catalogName);
            database.setOutputDefaultCatalog(true);
        }
        if (database.supportsSchemas() && schemaName != null) {
            database.setDefaultSchemaName(schemaName);
            database.setOutputDefaultSchema(true);
        }
        return liquibase;
    }

    protected abstract void run(Namespace var1, Liquibase var2) throws Exception;
}

