/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.ConfigOverride;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class DropwizardTestSupport<C extends Configuration> {
    private final Class<? extends Application<C>> applicationClass;
    private final String configPath;
    private final Set<ConfigOverride> configOverrides;
    private C configuration;
    private Application<C> application;
    private Environment environment;
    private Server jettyServer;
    private List<ServiceListener> listeners = Lists.newArrayList();

    public DropwizardTestSupport(Class<? extends Application<C>> applicationClass, @Nullable String configPath, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        this.configOverrides = ImmutableSet.copyOf((Object[])((Object[])MoreObjects.firstNonNull((Object)configOverrides, (Object)new ConfigOverride[0])));
    }

    public DropwizardTestSupport<C> addListener(ServiceListener<C> listener) {
        this.listeners.add(listener);
        return this;
    }

    public DropwizardTestSupport<C> manage(final Managed managed) {
        return this.addListener(new ServiceListener<C>(){

            @Override
            public void onRun(C configuration, Environment environment, DropwizardTestSupport<C> rule) throws Exception {
                environment.lifecycle().manage(managed);
            }
        });
    }

    public void before() {
        this.applyConfigOverrides();
        this.startIfRequired();
    }

    public void after() {
        for (ServiceListener listener : this.listeners) {
            try {
                listener.onStop(this);
            }
            catch (Exception exception) {}
        }
        this.resetConfigOverrides();
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.jettyServer = null;
        }
    }

    private void applyConfigOverrides() {
        for (ConfigOverride configOverride : this.configOverrides) {
            configOverride.addToSystemProperties();
        }
    }

    private void resetConfigOverrides() {
        for (ConfigOverride configOverride : this.configOverrides) {
            configOverride.removeFromSystemProperties();
        }
    }

    private void startIfRequired() {
        if (this.jettyServer != null) {
            return;
        }
        try {
            this.application = this.newApplication();
            Bootstrap bootstrap = new Bootstrap<C>(this.application){

                public void run(C configuration, Environment environment) throws Exception {
                    environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

                        public void serverStarted(Server server) {
                            DropwizardTestSupport.this.jettyServer = server;
                        }
                    });
                    DropwizardTestSupport.this.configuration = configuration;
                    DropwizardTestSupport.this.environment = environment;
                    super.run(configuration, environment);
                    for (ServiceListener listener : DropwizardTestSupport.this.listeners) {
                        try {
                            listener.onRun(configuration, environment, DropwizardTestSupport.this);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException("Error running app rule start listener", ex);
                        }
                    }
                }
            };
            this.application.initialize(bootstrap);
            ServerCommand command = new ServerCommand(this.application);
            ImmutableMap.Builder file = ImmutableMap.builder();
            if (!Strings.isNullOrEmpty((String)this.configPath)) {
                file.put((Object)"file", (Object)this.configPath);
            }
            Namespace namespace = new Namespace((Map)file.build());
            command.run(bootstrap, namespace);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public int getLocalPort() {
        return ((ServerConnector)this.jettyServer.getConnectors()[0]).getLocalPort();
    }

    public int getAdminPort() {
        return ((ServerConnector)this.jettyServer.getConnectors()[1]).getLocalPort();
    }

    public Application<C> newApplication() {
        try {
            return this.applicationClass.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <A extends Application<C>> A getApplication() {
        return (A)this.application;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ObjectMapper getObjectMapper() {
        return this.getEnvironment().getObjectMapper();
    }

    public static abstract class ServiceListener<T extends Configuration> {
        public void onRun(T configuration, Environment environment, DropwizardTestSupport<T> rule) throws Exception {
        }

        public void onStop(DropwizardTestSupport<T> rule) throws Exception {
        }
    }
}

