/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.validation.Validators;
import io.dropwizard.logging.BootstrapLogging;
import io.dropwizard.testing.junit.DropwizardTestResourceConfig;
import io.dropwizard.testing.junit.ResourceTestJerseyConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.validation.Validator;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ResourceTestRule
implements TestRule {
    private ResourceTestJerseyConfiguration configuration;
    private JerseyTest test;

    public static Builder builder() {
        return new Builder();
    }

    private ResourceTestRule(ResourceTestJerseyConfiguration configuration) {
        this.configuration = configuration;
    }

    public Validator getValidator() {
        return this.configuration.validator;
    }

    public ObjectMapper getObjectMapper() {
        return this.configuration.mapper;
    }

    public Consumer<ClientConfig> getClientConfigurator() {
        return this.configuration.clientConfigurator;
    }

    public WebTarget target(String path) {
        return this.getJerseyTest().target(path);
    }

    public Client client() {
        return this.test.client();
    }

    public JerseyTest getJerseyTest() {
        return this.test;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                DropwizardTestResourceConfig.CONFIGURATION_REGISTRY.put(ResourceTestRule.this.configuration.getId(), ResourceTestRule.this.configuration);
                try {
                    ResourceTestRule.this.test = new JerseyTest(){

                        protected TestContainerFactory getTestContainerFactory() {
                            return ((ResourceTestRule)ResourceTestRule.this).configuration.testContainerFactory;
                        }

                        protected DeploymentContext configureDeployment() {
                            return ServletDeploymentContext.builder((Application)new DropwizardTestResourceConfig(ResourceTestRule.this.configuration)).initParam("javax.ws.rs.Application", DropwizardTestResourceConfig.class.getName()).initParam("io.dropwizard.testing.junit.resourceTestJerseyConfigurationId", ResourceTestRule.this.configuration.getId()).build();
                        }

                        protected void configureClient(ClientConfig clientConfig) {
                            JacksonJsonProvider jsonProvider = new JacksonJsonProvider();
                            jsonProvider.setMapper(((ResourceTestRule)ResourceTestRule.this).configuration.mapper);
                            ((ResourceTestRule)ResourceTestRule.this).configuration.clientConfigurator.accept(clientConfig);
                            clientConfig.register((Object)jsonProvider);
                        }
                    };
                    ResourceTestRule.this.test.setUp();
                    base.evaluate();
                }
                finally {
                    DropwizardTestResourceConfig.CONFIGURATION_REGISTRY.remove(ResourceTestRule.this.configuration.getId());
                    ResourceTestRule.this.test.tearDown();
                }
            }
        };
    }

    static {
        BootstrapLogging.bootstrap();
    }

    public static class Builder {
        private final Set<Object> singletons = new HashSet<Object>();
        private final Set<Class<?>> providers = new HashSet();
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private ObjectMapper mapper = Jackson.newObjectMapper();
        private Validator validator = Validators.newValidator();
        private Consumer<ClientConfig> clientConfigurator = c -> {};
        private TestContainerFactory testContainerFactory = new InMemoryTestContainerFactory();
        private boolean registerDefaultExceptionMappers = true;

        public Builder setMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setValidator(Validator validator) {
            this.validator = validator;
            return this;
        }

        public Builder setClientConfigurator(Consumer<ClientConfig> clientConfigurator) {
            this.clientConfigurator = clientConfigurator;
            return this;
        }

        public Builder addResource(Object resource) {
            this.singletons.add(resource);
            return this;
        }

        public Builder addProvider(Class<?> klass) {
            this.providers.add(klass);
            return this;
        }

        public Builder addProvider(Object provider) {
            this.singletons.add(provider);
            return this;
        }

        public Builder addProperty(String property, Object value) {
            this.properties.put(property, value);
            return this;
        }

        public Builder setTestContainerFactory(TestContainerFactory factory) {
            this.testContainerFactory = factory;
            return this;
        }

        public Builder setRegisterDefaultExceptionMappers(boolean value) {
            this.registerDefaultExceptionMappers = value;
            return this;
        }

        public ResourceTestRule build() {
            return new ResourceTestRule(new ResourceTestJerseyConfiguration(this.singletons, this.providers, this.properties, this.mapper, this.validator, this.clientConfigurator, this.testContainerFactory, this.registerDefaultExceptionMappers));
        }
    }
}

