/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.util.SizeUnit;
import java.util.Locale;
import java.util.regex.Pattern;

public class Size {
    private static final Pattern PATTERN = Pattern.compile("[\\d]+[\\s]*(B|byte(s)?|KB|KiB|kilobyte(s)?|MB|MiB|megabyte(s)?|GB|GiB|gigabyte(s)?|TB|TiB|terabyte(s)?)");
    private static final ImmutableMap<String, SizeUnit> SUFFIXES;
    private final long count;
    private final SizeUnit unit;

    public static Size bytes(long count) {
        return new Size(count, SizeUnit.BYTES);
    }

    public static Size kilobytes(long count) {
        return new Size(count, SizeUnit.KILOBYTES);
    }

    public static Size megabytes(long count) {
        return new Size(count, SizeUnit.MEGABYTES);
    }

    public static Size gigabytes(long count) {
        return new Size(count, SizeUnit.GIGABYTES);
    }

    public static Size terabytes(long count) {
        return new Size(count, SizeUnit.TERABYTES);
    }

    private static long parseCount(String s) {
        Preconditions.checkArgument((boolean)PATTERN.matcher(s).matches(), (String)"Invalid size: %s", (Object[])new Object[]{s});
        String value = CharMatcher.WHITESPACE.removeFrom((CharSequence)s);
        return Long.parseLong(CharMatcher.JAVA_LETTER.trimTrailingFrom((CharSequence)value));
    }

    private static SizeUnit parseUnit(String s) {
        String value = CharMatcher.WHITESPACE.removeFrom((CharSequence)s);
        String suffix = CharMatcher.DIGIT.trimLeadingFrom((CharSequence)value).trim();
        return (SizeUnit)((Object)SUFFIXES.get((Object)suffix));
    }

    @JsonCreator
    public static Size parse(String size) {
        return new Size(Size.parseCount(size), Size.parseUnit(size));
    }

    private Size(long count, SizeUnit unit) {
        this.count = count;
        this.unit = (SizeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
    }

    public long getQuantity() {
        return this.count;
    }

    public SizeUnit getUnit() {
        return this.unit;
    }

    public long toBytes() {
        return SizeUnit.BYTES.convert(this.count, this.unit);
    }

    public long toKilobytes() {
        return SizeUnit.KILOBYTES.convert(this.count, this.unit);
    }

    public long toMegabytes() {
        return SizeUnit.MEGABYTES.convert(this.count, this.unit);
    }

    public long toGigabytes() {
        return SizeUnit.GIGABYTES.convert(this.count, this.unit);
    }

    public long toTerabytes() {
        return SizeUnit.TERABYTES.convert(this.count, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Size size = (Size)obj;
        return this.count == size.count && this.unit == size.unit;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + ' ' + units;
    }

    static {
        ImmutableMap.Builder suffixes = ImmutableMap.builder();
        suffixes.put((Object)"B", (Object)SizeUnit.BYTES);
        suffixes.put((Object)"byte", (Object)SizeUnit.BYTES);
        suffixes.put((Object)"bytes", (Object)SizeUnit.BYTES);
        suffixes.put((Object)"KB", (Object)SizeUnit.KILOBYTES);
        suffixes.put((Object)"KiB", (Object)SizeUnit.KILOBYTES);
        suffixes.put((Object)"kilobyte", (Object)SizeUnit.KILOBYTES);
        suffixes.put((Object)"kilobytes", (Object)SizeUnit.KILOBYTES);
        suffixes.put((Object)"MB", (Object)SizeUnit.MEGABYTES);
        suffixes.put((Object)"MiB", (Object)SizeUnit.MEGABYTES);
        suffixes.put((Object)"megabyte", (Object)SizeUnit.MEGABYTES);
        suffixes.put((Object)"megabytes", (Object)SizeUnit.MEGABYTES);
        suffixes.put((Object)"GB", (Object)SizeUnit.GIGABYTES);
        suffixes.put((Object)"GiB", (Object)SizeUnit.GIGABYTES);
        suffixes.put((Object)"gigabyte", (Object)SizeUnit.GIGABYTES);
        suffixes.put((Object)"gigabytes", (Object)SizeUnit.GIGABYTES);
        suffixes.put((Object)"TB", (Object)SizeUnit.TERABYTES);
        suffixes.put((Object)"TiB", (Object)SizeUnit.TERABYTES);
        suffixes.put((Object)"terabyte", (Object)SizeUnit.TERABYTES);
        suffixes.put((Object)"terabytes", (Object)SizeUnit.TERABYTES);
        SUFFIXES = suffixes.build();
    }
}

