/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;

public class Generics {
    private Generics() {
    }

    public static Class<?> getTypeParameter(Class<?> klass) {
        return Generics.getTypeParameter(klass, Object.class);
    }

    public static <T> Class<T> getTypeParameter(Class<?> klass, Class<? super T> bound) {
        Type t = Objects.requireNonNull(klass);
        while (t instanceof Class) {
            t = ((Class)t).getGenericSuperclass();
        }
        if (t instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType)t).getActualTypeArguments()) {
                Class<? super T> cls;
                Type rawType;
                if (param instanceof Class) {
                    Type[] cls2 = Generics.determineClass(bound, param);
                    if (cls2 == null) continue;
                    return cls2;
                }
                if (param instanceof TypeVariable) {
                    for (Type paramBound : ((TypeVariable)param).getBounds()) {
                        Class<? super T> cls3;
                        if (!(paramBound instanceof Class) || (cls3 = Generics.determineClass(bound, paramBound)) == null) continue;
                        return cls3;
                    }
                    continue;
                }
                if (!(param instanceof ParameterizedType) || !((rawType = ((ParameterizedType)param).getRawType()) instanceof Class) || (cls = Generics.determineClass(bound, rawType)) == null) continue;
                return cls;
            }
        }
        throw new IllegalStateException("Cannot figure out type parameterization for " + klass.getName());
    }

    private static <T> Class<T> determineClass(Class<? super T> bound, Type candidate) {
        Class cls;
        if (candidate instanceof Class && bound.isAssignableFrom(cls = (Class)candidate)) {
            return cls;
        }
        return null;
    }
}

