/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.validation.MaxDuration;
import io.dropwizard.validation.MinDuration;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;
import javax.validation.Constraint;
import javax.validation.OverridesAttribute;
import javax.validation.Payload;
import javax.validation.ReportAsSingleViolation;

@Documented
@Constraint(validatedBy={})
@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@MinDuration(value=0L)
@MaxDuration(value=0x7FFFFFFFFFFFFFFFL, unit=TimeUnit.DAYS)
@ReportAsSingleViolation
public @interface DurationRange {
    @OverridesAttribute(constraint=MinDuration.class, name="value")
    public long min() default 0L;

    @OverridesAttribute(constraint=MaxDuration.class, name="value")
    public long max() default 0x7FFFFFFFFFFFFFFFL;

    @OverridesAttribute.List(value={@OverridesAttribute(constraint=MinDuration.class, name="unit"), @OverridesAttribute(constraint=MaxDuration.class, name="unit")})
    public TimeUnit unit() default TimeUnit.SECONDS;

    public String message() default "must be between {min} {unit} and {max} {unit}";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.ANNOTATION_TYPE, ElementType.CONSTRUCTOR, ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public DurationRange[] value();
    }
}

