/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class AgentManifest {
    private final Set<String> entityPackages = new HashSet<String>();
    private final Set<String> transactionalPackages = new HashSet<String>();
    private final Set<String> querybeanPackages = new HashSet<String>();

    public static AgentManifest read(ClassLoader classLoader, Set<String> initialPackages) {
        try {
            return new AgentManifest(initialPackages).readManifests(classLoader, "META-INF/ebean-typequery.mf").readManifests(classLoader, "META-INF/ebean.mf").readManifests(classLoader, "ebean.mf");
        }
        catch (IOException e) {
            System.err.println("Agent: error reading ebean manifest resources");
            e.printStackTrace();
            return new AgentManifest();
        }
    }

    public AgentManifest(Set<String> initialPackages) {
        if (initialPackages != null) {
            this.entityPackages.addAll(initialPackages);
        }
    }

    public AgentManifest() {
    }

    public String toString() {
        return "entityPackages:" + this.entityPackages + " querybeanPackages:" + this.querybeanPackages + " transactionalPackages:" + this.transactionalPackages;
    }

    public Set<String> getEntityPackages() {
        return this.entityPackages;
    }

    public boolean isTransactionalNone() {
        return this.transactionalPackages.contains("none") && this.transactionalPackages.size() == 1;
    }

    public boolean isQueryBeanNone() {
        return this.querybeanPackages.contains("none") && this.querybeanPackages.size() == 1;
    }

    public Set<String> getTransactionalPackages() {
        return this.transactionalPackages;
    }

    public Set<String> getQuerybeanPackages() {
        return this.querybeanPackages;
    }

    AgentManifest readManifests(ClassLoader classLoader, String path) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                this.addResource(url.openStream());
            }
            catch (IOException e) {
                System.err.println("Error reading manifest resources " + url);
                e.printStackTrace();
            }
        }
        return this;
    }

    public void addResource(InputStream is) throws IOException {
        try {
            this.addManifest(new Manifest(is));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                System.err.println("Error closing manifest resource");
                e.printStackTrace();
            }
        }
    }

    private void addManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.add(this.entityPackages, attributes.getValue("packages"));
        this.add(this.entityPackages, attributes.getValue("entity-packages"));
        this.add(this.transactionalPackages, attributes.getValue("transactional-packages"));
        this.add(this.querybeanPackages, attributes.getValue("querybean-packages"));
    }

    private void add(Set<String> addTo, String packages) {
        if (packages != null) {
            String[] split;
            for (String aSplit : split = packages.split(",|;| ")) {
                String pkg = aSplit.trim();
                if (pkg.isEmpty()) continue;
                addTo.add(pkg);
            }
        }
    }
}

