/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.common.AgentManifest;
import io.ebean.enhance.common.ArgParser;
import io.ebean.enhance.common.ClassBytesReader;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.ClassMetaReader;
import io.ebean.enhance.common.FilterEntityTransactional;
import io.ebean.enhance.common.FilterQueryBean;
import io.ebean.enhance.common.IgnoreClassHelper;
import io.ebean.enhance.common.SysoutMessageOutput;
import io.ebean.enhance.entity.MessageOutput;
import io.ebean.enhance.querybean.DetectQueryBean;
import io.ebean.enhance.querybean.Distill;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnhanceContext {
    private static final Logger logger = Logger.getLogger(EnhanceContext.class.getName());
    private final IgnoreClassHelper ignoreClassHelper;
    private final HashMap<String, String> agentArgsMap;
    private final boolean transientInternalFields;
    private final boolean checkNullManyFields;
    private final ClassMetaReader reader;
    private final ClassBytesReader classBytesReader;
    private MessageOutput logout;
    private int logLevel;
    private HashMap<String, ClassMeta> map = new HashMap();
    private final DetectQueryBean detectQueryBean;
    private final FilterEntityTransactional filterEntityTransactional;
    private final FilterQueryBean filterQueryBean;

    public EnhanceContext(ClassBytesReader classBytesReader, String agentArgs, AgentManifest manifest) {
        this.agentArgsMap = ArgParser.parse(agentArgs);
        this.filterEntityTransactional = new FilterEntityTransactional(manifest);
        this.filterQueryBean = new FilterQueryBean(manifest);
        this.detectQueryBean = Distill.convert(manifest.getEntityPackages());
        if (this.detectQueryBean.isEmpty()) {
            logger.log(Level.FINE, "No ebean.mf detected");
        }
        this.ignoreClassHelper = new IgnoreClassHelper();
        this.logout = new SysoutMessageOutput(System.out);
        this.classBytesReader = classBytesReader;
        this.reader = new ClassMetaReader(this);
        String debugValue = this.agentArgsMap.get("debug");
        if (debugValue != null) {
            try {
                this.logLevel = Integer.parseInt(debugValue);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Agent debug argument [" + debugValue + "] is not an int?");
            }
        }
        this.transientInternalFields = this.getPropertyBoolean("transientInternalFields", false);
        this.checkNullManyFields = this.getPropertyBoolean("checkNullManyFields", true);
    }

    public byte[] getClassBytes(String className, ClassLoader classLoader) {
        return this.classBytesReader.getClassBytes(className, classLoader);
    }

    public boolean isQueryBean(String owner) {
        return this.detectQueryBean.isQueryBean(owner);
    }

    public String getProperty(String key) {
        return this.agentArgsMap.get(key.toLowerCase());
    }

    public boolean getPropertyBoolean(String key, boolean dflt) {
        String s = this.getProperty(key);
        if (s == null) {
            return dflt;
        }
        return s.trim().equalsIgnoreCase("true");
    }

    public boolean detectEntityTransactionalEnhancement(String className) {
        return this.filterEntityTransactional.detectEnhancement(className);
    }

    public boolean detectQueryBeanEnhancement(String className) {
        return this.filterQueryBean.detectEnhancement(className);
    }

    public boolean isIgnoreClass(String className) {
        return this.ignoreClassHelper.isIgnoreClass(className);
    }

    public void setLogout(MessageOutput logout) {
        this.logout = logout;
    }

    public ClassMeta createClassMeta() {
        return new ClassMeta(this, this.logLevel, this.logout);
    }

    public ClassMeta getSuperMeta(String superClassName, ClassLoader classLoader) {
        try {
            if (this.isIgnoreClass(superClassName)) {
                return null;
            }
            return this.reader.get(false, superClassName, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassMeta getInterfaceMeta(String interfaceClassName, ClassLoader classLoader) {
        try {
            if (this.isIgnoreClass(interfaceClassName)) {
                return null;
            }
            return this.reader.get(true, interfaceClassName, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addClassMeta(ClassMeta meta) {
        this.map.put(meta.getClassName(), meta);
    }

    public ClassMeta get(String className) {
        return this.map.get(className);
    }

    public void log(int level, String className, String msg) {
        if (this.logLevel >= level) {
            this.log(className, msg);
        }
    }

    public void log(String className, String msg) {
        if (className != null) {
            msg = "cls: " + className + "  msg: " + msg;
        }
        this.logout.println("ebean-enhance> " + msg);
    }

    public boolean isLog(int level) {
        return this.logLevel >= level;
    }

    public void log(Throwable e) {
        e.printStackTrace(new PrintStream(new ByteArrayOutputStream()){

            @Override
            public void print(String message) {
                EnhanceContext.this.logout.println(message);
            }

            @Override
            public void println(String message) {
                EnhanceContext.this.logout.println(message);
            }
        });
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public boolean isTransientInternalFields() {
        return this.transientInternalFields;
    }

    public boolean isCheckNullManyFields() {
        return this.checkNullManyFields;
    }
}

