/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.common.EntityCheck;
import io.ebean.enhance.common.NoEnhancementRequiredException;

public class DetectEnhancement
extends ClassVisitor {
    private final ClassLoader classLoader;
    private final EnhanceContext enhanceContext;
    private final DetectTransactionalMethod detectTransactionalMethod = new DetectTransactionalMethod();
    private String className;
    private boolean entity;
    private boolean enhancedEntity;
    private boolean transactional;
    private boolean enhancedTransactional;

    public DetectEnhancement(ClassLoader classLoader, EnhanceContext context) {
        super(393216);
        this.classLoader = classLoader;
        this.enhanceContext = context;
    }

    public boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    public void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }

    public void log(int level, String msg) {
        if (this.isLog(level)) {
            this.log(msg);
        }
    }

    public boolean isEnhancedEntity() {
        return this.enhancedEntity;
    }

    public boolean isEnhancedTransactional() {
        return this.enhancedTransactional;
    }

    public boolean isEntity() {
        return this.entity;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x200) != 0) {
            throw new NoEnhancementRequiredException("Interface type");
        }
        this.className = name;
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals("io/ebean/bean/EntityBean")) {
                this.enhancedEntity = true;
                this.entity = true;
                continue;
            }
            if (interfaces[i].equals("io/ebean/bean/EnhancedTransactional")) {
                this.enhancedTransactional = true;
                continue;
            }
            ClassMeta interfaceMeta = this.enhanceContext.getInterfaceMeta(interfaces[i], this.classLoader);
            if (interfaceMeta == null || !interfaceMeta.isTransactional()) continue;
            this.transactional = true;
            if (!this.isLog(9)) continue;
            this.log("detected implements transactional interface " + interfaceMeta);
        }
        if (this.isLog(4)) {
            this.log("interfaces:  enhancedEntity[" + this.enhancedEntity + "] transactional[" + this.enhancedTransactional + "]");
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isEntityAnnotation(desc)) {
            if (this.isLog(5)) {
                this.log("found entity annotation " + desc);
            }
            this.entity = true;
        } else if (desc.equals("Lio/ebean/annotation/Transactional;")) {
            if (this.isLog(5)) {
                this.log("found transactional annotation " + desc);
            }
            this.transactional = true;
        }
        return null;
    }

    private boolean isEntityAnnotation(String desc) {
        return EntityCheck.isEntityAnnotation(desc);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return this.detectTransactionalMethod;
    }

    private class DetectTransactionalMethod
    extends MethodVisitor {
        DetectTransactionalMethod() {
            super(393216);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals("Lio/ebean/annotation/Transactional;")) {
                DetectEnhancement.this.transactional = true;
            }
            return null;
        }
    }
}

