/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.common;

import java.util.HashSet;
import java.util.Set;

class IgnoreClassHelper {
    private static final Set<String> ignoreOneLevel = new HashSet<String>();
    private static final Set<String> ignoreTwoLevel = new HashSet<String>();

    IgnoreClassHelper() {
    }

    boolean isIgnoreClass(String className) {
        if (className == null) {
            return true;
        }
        if ((className = className.replace('.', '/')).equals("io/ebean/Model")) {
            return false;
        }
        if (className.startsWith("$")) {
            return true;
        }
        int firstSlash = className.indexOf(47);
        if (firstSlash == -1) {
            return true;
        }
        String firstPackage = className.substring(0, firstSlash);
        if (ignoreOneLevel.contains(firstPackage)) {
            return true;
        }
        int secondSlash = className.indexOf(47, firstSlash + 1);
        if (secondSlash == -1) {
            return false;
        }
        String secondPackage = className.substring(0, secondSlash);
        return ignoreTwoLevel.contains(secondPackage);
    }

    static {
        ignoreOneLevel.add("java");
        ignoreOneLevel.add("javax");
        ignoreOneLevel.add("play");
        ignoreOneLevel.add("sbt");
        ignoreOneLevel.add("scala");
        ignoreOneLevel.add("sun");
        ignoreOneLevel.add("sunw");
        ignoreOneLevel.add("oracle");
        ignoreOneLevel.add("groovy");
        ignoreOneLevel.add("kotlin");
        ignoreOneLevel.add("junit");
        ignoreOneLevel.add("microsoft");
        ignoreTwoLevel.add("com/sun");
        ignoreTwoLevel.add("org/aopalliance");
        ignoreTwoLevel.add("org/wc3");
        ignoreTwoLevel.add("org/xml");
        ignoreTwoLevel.add("org/junit");
        ignoreTwoLevel.add("org/apache");
        ignoreTwoLevel.add("org/eclipse");
        ignoreTwoLevel.add("org/jetbrains");
        ignoreTwoLevel.add("org/joda");
        ignoreTwoLevel.add("com/mysql");
        ignoreTwoLevel.add("org/postgresql");
        ignoreTwoLevel.add("org/h2");
        ignoreTwoLevel.add("com/h2database");
        ignoreTwoLevel.add("org/hsqldb");
        ignoreTwoLevel.add("org/ibex");
        ignoreTwoLevel.add("org/sqlite");
        ignoreTwoLevel.add("ch/qos");
        ignoreTwoLevel.add("org/slf4j");
        ignoreTwoLevel.add("org/codehaus");
        ignoreTwoLevel.add("com/fasterxml");
        ignoreTwoLevel.add("org/assertj");
        ignoreTwoLevel.add("org/hamcrest");
        ignoreTwoLevel.add("org/mockito");
        ignoreTwoLevel.add("org/objenesis");
        ignoreTwoLevel.add("org/objectweb");
        ignoreTwoLevel.add("org/jboss");
        ignoreTwoLevel.add("org/testng");
        ignoreTwoLevel.add("com/intellij");
        ignoreTwoLevel.add("com/google");
        ignoreTwoLevel.add("com/squareup");
        ignoreTwoLevel.add("com/microsoft");
        ignoreTwoLevel.add("org/avaje");
        ignoreTwoLevel.add("io/ebean");
        ignoreTwoLevel.add("io/ebeaninternal");
        ignoreTwoLevel.add("io/ebeanservice");
    }
}

