/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.enhance.transactional;

import io.ebean.enhance.asm.AnnotationVisitor;
import io.ebean.enhance.asm.ClassVisitor;
import io.ebean.enhance.asm.FieldVisitor;
import io.ebean.enhance.asm.Label;
import io.ebean.enhance.asm.MethodVisitor;
import io.ebean.enhance.common.AlreadyEnhancedException;
import io.ebean.enhance.common.AnnotationInfo;
import io.ebean.enhance.common.AnnotationInfoVisitor;
import io.ebean.enhance.common.ClassMeta;
import io.ebean.enhance.common.EnhanceContext;
import io.ebean.enhance.common.NoEnhancementRequiredException;
import io.ebean.enhance.transactional.ScopeTransAdapter;
import io.ebean.enhance.transactional.StaticInitAdapter;
import io.ebean.enhance.transactional.TransactionalMethodKey;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassAdapterTransactional
extends ClassVisitor {
    private static final Logger logger = Logger.getLogger(ClassAdapterTransactional.class.getName());
    static final String QP_FIELD_PREFIX = "_$ebpq";
    static final String TX_FIELD_PREFIX = "_$ebpt";
    static final String IO_EBEAN_FINDER = "io/ebean/Finder";
    private final Set<String> transactionalMethods = new LinkedHashSet<String>();
    private final Set<Integer> transactionalLineNumbers = new LinkedHashSet<Integer>();
    private final EnhanceContext enhanceContext;
    private final ClassLoader classLoader;
    private ArrayList<ClassMeta> transactionalInterfaces = new ArrayList();
    private AnnotationInfo classAnnotationInfo;
    private String className;
    private boolean existingStaticInitialiser;
    private boolean finder;
    private int queryProfileCount;
    private int transactionProfileCount;
    private Map<Integer, String> txLabels = new LinkedHashMap<Integer, String>();

    public ClassAdapterTransactional(ClassVisitor cv, ClassLoader classLoader, EnhanceContext context) {
        super(393216, cv);
        this.classLoader = classLoader;
        this.enhanceContext = context;
    }

    public String className() {
        return this.className;
    }

    public boolean isLog(int level) {
        return this.enhanceContext.isLog(level);
    }

    public void log(String msg) {
        this.enhanceContext.log(this.className, msg);
    }

    public AnnotationInfo getClassAnnotationInfo() {
        return this.classAnnotationInfo;
    }

    public AnnotationInfo getInterfaceTransactionalInfo(String methodName, String methodDesc) {
        AnnotationInfo interfaceAnnotationInfo = null;
        for (int i = 0; i < this.transactionalInterfaces.size(); ++i) {
            ClassMeta interfaceMeta = this.transactionalInterfaces.get(i);
            AnnotationInfo ai = interfaceMeta.getInterfaceTransactionalInfo(methodName, methodDesc);
            if (ai == null) continue;
            if (interfaceAnnotationInfo != null) {
                String msg = "Error in [" + this.className + "] searching the transactional interfaces [" + this.transactionalInterfaces + "] found more than one match for the transactional method:" + methodName + " " + methodDesc;
                logger.log(Level.SEVERE, msg);
                continue;
            }
            interfaceAnnotationInfo = ai;
            if (!this.isLog(2)) continue;
            this.log("inherit transactional from interface [" + interfaceMeta + "] method[" + methodName + " " + methodDesc + "]");
        }
        return interfaceAnnotationInfo;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        this.finder = superName.equals(IO_EBEAN_FINDER);
        int n = 1 + interfaces.length;
        String[] newInterfaces = new String[n];
        for (int i = 0; i < interfaces.length; ++i) {
            newInterfaces[i] = interfaces[i];
            if (newInterfaces[i].equals("io/ebean/bean/EnhancedTransactional")) {
                throw new AlreadyEnhancedException(name);
            }
            ClassMeta interfaceMeta = this.enhanceContext.getInterfaceMeta(newInterfaces[i], this.classLoader);
            if (interfaceMeta == null || !interfaceMeta.isTransactional()) continue;
            this.transactionalInterfaces.add(interfaceMeta);
            if (!this.isLog(6)) continue;
            this.log(" implements transactional interface " + interfaceMeta.getDescription());
        }
        newInterfaces[newInterfaces.length - 1] = "io/ebean/bean/EnhancedTransactional";
        super.visit(version, access, name, signature, superName, newInterfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (desc.equals("Lio/ebean/annotation/Transactional;")) {
            this.classAnnotationInfo = new AnnotationInfo(null);
            return new AnnotationInfoVisitor(null, this.classAnnotationInfo, av);
        }
        return av;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.startsWith("_$ebp") && desc.equals("Lio/ebean/ProfileLocation;")) {
            throw new AlreadyEnhancedException(this.className);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("_$initProfileLocations")) {
            throw new AlreadyEnhancedException(this.className);
        }
        if (name.equals("<init>")) {
            return mv;
        }
        if (name.equals("<clinit>")) {
            if (!this.enhanceContext.isEnableProfileLocation()) {
                return mv;
            }
            if (this.isLog(3)) {
                this.log("... <clinit> exists - adding call to _$initProfileLocations()");
            }
            this.existingStaticInitialiser = true;
            return new StaticInitAdapter(mv, access, name, desc, this.className);
        }
        return new ScopeTransAdapter(this, mv, access, name, desc);
    }

    @Override
    public void visitEnd() {
        if (this.queryProfileCount == 0 && this.transactionProfileCount == 0) {
            throw new NoEnhancementRequiredException(this.className);
        }
        if (this.isLog(2)) {
            this.log("methods:" + this.transactionalMethods + " qp:" + this.queryProfileCount + " tp:" + this.transactionProfileCount + " profileLocation:" + this.isEnableProfileLocation());
        }
        if (this.enhanceContext.isEnableProfileLocation()) {
            this.addStaticFieldDefinitions();
            this.addStaticFieldInitialisers();
            if (!this.existingStaticInitialiser) {
                if (this.isLog(5)) {
                    this.log("... add <clinit> to call _$initProfileLocations()");
                }
                this.addStaticInitialiser();
            }
        }
        super.visitEnd();
    }

    private void addStaticFieldDefinitions() {
        FieldVisitor fv;
        int i;
        for (i = 0; i < this.queryProfileCount; ++i) {
            fv = this.cv.visitField(10, QP_FIELD_PREFIX + i, "Lio/ebean/ProfileLocation;", null, null);
            fv.visitEnd();
        }
        for (i = 0; i < this.transactionProfileCount; ++i) {
            fv = this.cv.visitField(10, TX_FIELD_PREFIX + i, "Lio/ebean/ProfileLocation;", null, null);
            fv.visitEnd();
        }
    }

    private void addStaticFieldInitialisers() {
        MethodVisitor mv = this.cv.visitMethod(10, "_$initProfileLocations", "()V", null, null);
        mv.visitCode();
        for (int i = 0; i < this.queryProfileCount; ++i) {
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1, l0);
            mv.visitMethodInsn(184, "io/ebean/ProfileLocation", "create", "()Lio/ebean/ProfileLocation;", true);
            mv.visitFieldInsn(179, this.className, QP_FIELD_PREFIX + i, "Lio/ebean/ProfileLocation;");
        }
        boolean withLineNumbers = this.transactionProfileCount == this.transactionalLineNumbers.size();
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>(this.transactionalLineNumbers);
        for (int i = 0; i < this.transactionProfileCount; ++i) {
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(2, l0);
            if (withLineNumbers) {
                int txnLineNumber = (Integer)lineNumbers.get(i);
                mv.visitIntInsn(16, txnLineNumber);
                String label = this.getTxnLabel(i);
                mv.visitLdcInsn(label);
                mv.visitMethodInsn(184, "io/ebean/ProfileLocation", "create", "(ILjava/lang/String;)Lio/ebean/ProfileLocation;", true);
            } else {
                mv.visitMethodInsn(184, "io/ebean/ProfileLocation", "create", "()Lio/ebean/ProfileLocation;", true);
            }
            mv.visitFieldInsn(179, this.className, TX_FIELD_PREFIX + i, "Lio/ebean/ProfileLocation;");
        }
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(3, l1);
        mv.visitInsn(177);
        mv.visitMaxs(1, 0);
        mv.visitEnd();
    }

    private String getTxnLabel(int i) {
        String label = this.txLabels.get(i);
        return label != null ? label : "";
    }

    private void addStaticInitialiser() {
        MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(4, l0);
        mv.visitMethodInsn(184, this.className, "_$initProfileLocations", "()V", false);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(5, l1);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    void transactionalMethod(TransactionalMethodKey methodKey) {
        this.transactionalLineNumbers.add(methodKey.getLineNumber());
        this.transactionalMethods.add(methodKey.getMethodName());
        if (this.isLog(3)) {
            this.log("method - " + methodKey);
        }
    }

    public TransactionalMethodKey createMethodKey(String methodName, String methodDesc, int profId) {
        return this.enhanceContext.createMethodKey(this.className, methodName, methodDesc, profId);
    }

    public boolean isEnableProfileLocation() {
        return this.enhanceContext.isEnableProfileLocation();
    }

    int nextQueryProfileLocation() {
        return this.queryProfileCount++;
    }

    int nextTransactionLocation() {
        return this.transactionProfileCount++;
    }

    public boolean isFinderProfileLocation() {
        return this.finder && this.isEnableProfileLocation();
    }

    public void putTxnLabel(int locationField, String txLabel) {
        this.txLabels.put(locationField, txLabel);
    }
}

