/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.maven.core.config.BuildRecreateMode;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.Task;

public interface BuildService {
    public void build(BuildServiceConfig var1, ImageConfiguration var2) throws Fabric8ServiceException;

    public static class BuildServiceConfig {
        private BuildService.BuildContext dockerBuildContext;
        private MojoParameters dockerMojoParameters;
        private BuildRecreateMode buildRecreateMode;
        private OpenShiftBuildStrategy openshiftBuildStrategy;
        private String s2iBuildNameSuffix;
        private Task<KubernetesListBuilder> enricherTask;
        private String buildDirectory;

        public BuildService.BuildContext getDockerBuildContext() {
            return this.dockerBuildContext;
        }

        public MojoParameters getDockerMojoParameters() {
            return this.dockerMojoParameters;
        }

        public BuildRecreateMode getBuildRecreateMode() {
            return this.buildRecreateMode;
        }

        public OpenShiftBuildStrategy getOpenshiftBuildStrategy() {
            return this.openshiftBuildStrategy;
        }

        public String getS2iBuildNameSuffix() {
            return this.s2iBuildNameSuffix;
        }

        public Task<KubernetesListBuilder> getEnricherTask() {
            return this.enricherTask;
        }

        public String getBuildDirectory() {
            return this.buildDirectory;
        }

        public static class Builder {
            private BuildServiceConfig config;

            public Builder() {
                this.config = new BuildServiceConfig();
            }

            public Builder(BuildServiceConfig config) {
                this.config = config;
            }

            public Builder dockerBuildContext(BuildService.BuildContext dockerBuildContext) {
                this.config.dockerBuildContext = dockerBuildContext;
                return this;
            }

            public Builder dockerMojoParameters(MojoParameters dockerMojoParameters) {
                this.config.dockerMojoParameters = dockerMojoParameters;
                return this;
            }

            public Builder buildRecreateMode(BuildRecreateMode buildRecreateMode) {
                this.config.buildRecreateMode = buildRecreateMode;
                return this;
            }

            public Builder openshiftBuildStrategy(OpenShiftBuildStrategy openshiftBuildStrategy) {
                this.config.openshiftBuildStrategy = openshiftBuildStrategy;
                return this;
            }

            public Builder s2iBuildNameSuffix(String s2iBuildNameSuffix) {
                this.config.s2iBuildNameSuffix = s2iBuildNameSuffix;
                return this;
            }

            public Builder enricherTask(Task<KubernetesListBuilder> enricherTask) {
                this.config.enricherTask = enricherTask;
                return this;
            }

            public Builder buildDirectory(String buildDirectory) {
                this.config.buildDirectory = buildDirectory;
                return this;
            }

            public BuildServiceConfig build() {
                return this.config;
            }
        }
    }
}

