/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.PlatformMode;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.kubernetes.DockerBuildService;
import io.fabric8.maven.core.service.openshift.OpenshiftBuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.OpenShiftClient;

public class Fabric8ServiceHub {
    private BuildService buildService;

    public Fabric8ServiceHub(ClusterAccess clusterAccess, PlatformMode mode, Logger log, ServiceHub dockerServiceHub) {
        PlatformMode resolvedMode = clusterAccess.resolvePlatformMode(mode, log);
        KubernetesClient client = clusterAccess.createDefaultClient(log);
        if (resolvedMode == PlatformMode.kubernetes) {
            this.buildService = new DockerBuildService(dockerServiceHub);
        } else if (resolvedMode == PlatformMode.openshift) {
            this.buildService = new OpenshiftBuildService((OpenShiftClient)client, log, dockerServiceHub);
        } else {
            throw new IllegalArgumentException("Unknown platform mode " + (Object)((Object)mode) + " resolved as " + (Object)((Object)resolvedMode));
        }
    }

    public BuildService getBuildService() {
        return this.buildService;
    }
}

