/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.kubernetes;

import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;

public class DockerBuildService
implements BuildService {
    private ServiceHub dockerServiceHub;

    public DockerBuildService(ServiceHub dockerServiceHub) {
        this.dockerServiceHub = dockerServiceHub;
    }

    @Override
    public void build(BuildService.BuildServiceConfig config, ImageConfiguration imageConfig) throws Fabric8ServiceException {
        io.fabric8.maven.docker.service.BuildService dockerBuildService = this.dockerServiceHub.getBuildService();
        BuildService.BuildContext dockerBuildContext = config.getDockerBuildContext();
        try {
            dockerBuildService.buildImage(imageConfig, dockerBuildContext);
            dockerBuildService.tagImage(imageConfig.getName(), imageConfig);
        }
        catch (Exception ex) {
            throw new Fabric8ServiceException("Error while trying to build the image", ex);
        }
    }
}

