/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.ImageStreamStatus;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class ImageStreamService {
    private final OpenShiftClient client;
    private final Logger log;
    private final int IMAGE_STREAM_TAG_RETRIES = 15;
    private final long IMAGE_STREAM_TAG_RETRY_TIMEOUT_IN_MILLIS = 1000L;

    public ImageStreamService(OpenShiftClient client, Logger log) {
        this.client = client;
        this.log = log;
    }

    public void saveImageStreamResource(ImageName imageName, File target) throws MojoExecutionException {
        String tag = Strings.isNullOrBlank((String)imageName.getTag()) ? "latest" : imageName.getTag();
        try {
            ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((TagReferenceFluent.FromNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(imageName.getSimpleName())).endMetadata()).withNewSpec().addNewTag().withName(tag)).withNewFrom().withKind("ImageStreamImage")).endFrom()).endTag()).endSpec()).build();
            this.createOrUpdateImageStreamTag(this.client, imageName, is);
            File fullTargetFile = this.writeImageStreamToFile(is, target);
            this.log.info("ImageStream %s written to %s", new Object[]{imageName.getSimpleName(), fullTargetFile});
        }
        catch (KubernetesClientException e) {
            KubernetesResourceUtil.handleKubernetesClientException(e, this.log);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File writeImageStreamToFile(ImageStream is, File target) throws MojoExecutionException, IOException {
        File targetWithoutExt;
        ResourceFileType type;
        KubernetesList entity = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(new HasMetadata[]{is})).build();
        String ext = "";
        try {
            ext = FilenameUtils.getExtension((String)target.getPath());
            type = ResourceFileType.fromExtension(ext);
            String p = target.getAbsolutePath();
            targetWithoutExt = new File(p.substring(0, p.length() - ext.length() - 1));
        }
        catch (IllegalArgumentException exp) {
            throw new MojoExecutionException(String.format("Invalid extension '%s' for ImageStream target file '%s'. Allowed extensions: yml, json", ext, target.getPath()), (Exception)exp);
        }
        return KubernetesResourceUtil.writeResource(entity, targetWithoutExt, type);
    }

    private void createOrUpdateImageStreamTag(OpenShiftClient client, ImageName image, ImageStream is) throws MojoExecutionException {
        String namespace = client.getNamespace();
        String tagSha = this.findTagSha(client, image.getSimpleName(), client.getNamespace());
        String name = image.getSimpleName() + "@" + tagSha;
        TagReference tag = this.extractTag(is);
        ObjectReference from = this.extractFrom(tag);
        if (!Objects.equals(image.getTag(), tag.getName())) {
            tag.setName(image.getTag());
        }
        if (!Objects.equals("ImageStreamImage", from.getKind())) {
            from.setKind("ImageStreamImage");
        }
        if (!Objects.equals(namespace, from.getNamespace())) {
            from.setNamespace(namespace);
        }
        if (!Objects.equals(name, from.getName())) {
            from.setName(name);
        }
    }

    private ObjectReference extractFrom(TagReference tag) {
        ObjectReference from = tag.getFrom();
        if (from == null) {
            from = new ObjectReference();
            tag.setFrom(from);
        }
        return from;
    }

    private TagReference extractTag(ImageStream is) {
        ArrayList<TagReference> tags;
        ImageStreamSpec spec = is.getSpec();
        if (spec == null) {
            spec = new ImageStreamSpec();
            is.setSpec(spec);
        }
        if ((tags = spec.getTags()) == null) {
            tags = new ArrayList<TagReference>();
            spec.setTags(tags);
        }
        TagReference tag = null;
        if (tags.isEmpty()) {
            tag = new TagReference();
            tags.add(tag);
        } else {
            tag = (TagReference)tags.get(tags.size() - 1);
        }
        return tag;
    }

    private String findTagSha(OpenShiftClient client, String imageStreamName, String namespace) throws MojoExecutionException {
        ImageStream currentImageStream = null;
        for (int i = 0; i < 15; ++i) {
            List tags;
            ImageStreamStatus status;
            if (i > 0) {
                this.log.info("Retrying to find tag on ImageStream %s", new Object[]{imageStreamName});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.debug("interrupted", new Object[]{e});
                }
            }
            if ((currentImageStream = (ImageStream)((ClientResource)client.imageStreams().withName(imageStreamName)).get()) == null || (status = currentImageStream.getStatus()) == null || (tags = status.getTags()) == null || tags.isEmpty()) continue;
            for (NamedTagEventList list : tags) {
                List items = list.getItems();
                if (items == null) continue;
                for (TagEvent item : items) {
                    String image = item.getImage();
                    if (!Strings.isNotBlank((String)image)) continue;
                    this.log.info("Found tag on ImageStream " + imageStreamName + " tag: " + image, new Object[0]);
                    return image;
                }
            }
        }
        if (currentImageStream == null) {
            throw new MojoExecutionException("Could not find a current ImageStream with name " + imageStreamName + " in namespace " + namespace);
        }
        throw new MojoExecutionException("Could not find a tag in the ImageStream " + imageStreamName);
    }
}

