/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.maven.plugin.MojoExecutionException;

public class IoUtil {
    private static int PROGRESS_LENGTH = 50;

    public static void download(Logger log, URL downloadUrl, File target) throws MojoExecutionException {
        log.progressStart();
        try {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.MINUTES).build();
            Request request = new Request.Builder().url(downloadUrl).build();
            Response response = client.newCall(request).execute();
            try (FileOutputStream out = new FileOutputStream(target);
                 InputStream im = response.body().byteStream();){
                long length = response.body().contentLength();
                InputStream in = response.body().byteStream();
                byte[] buffer = new byte[8192];
                long readBytes = 0L;
                while (true) {
                    int len = in.read(buffer);
                    log.progressUpdate(target.getName(), "Downloading", IoUtil.getProgressBar(readBytes += (long)len, length));
                    if (len <= 0) {
                        out.flush();
                        break;
                    }
                    ((OutputStream)out).write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to download URL " + downloadUrl + " to  " + target + ": " + e, (Exception)e);
        }
        finally {
            log.progressFinished();
        }
    }

    private static String getProgressBar(long bytesRead, long length) {
        StringBuffer ret = new StringBuffer("[");
        if (length > -1L) {
            int bucketSize = (int)((double)(length / (long)PROGRESS_LENGTH) + 0.5);
            int index = (int)((double)(bytesRead / (long)bucketSize) + 0.5);
            for (int i = 0; i < PROGRESS_LENGTH; ++i) {
                ret.append(i < index ? "=" : (i == index ? ">" : " "));
            }
            ret.append(String.format("] %.2f MB/%.2f MB", Float.valueOf((float)bytesRead / 1048576.0f), Float.valueOf((float)length / 1048576.0f)));
        } else {
            int bucketSize = 204800;
            int index = (int)((double)(bytesRead / (long)bucketSize) + 0.5) % PROGRESS_LENGTH;
            for (int i = 0; i < PROGRESS_LENGTH; ++i) {
                ret.append(i == index ? "*" : " ");
            }
            ret.append("]");
        }
        return ret.toString();
    }
}

