/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.util.ClassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.shared.utils.StringUtils;

public class ProfileUtil {
    public static final String[] PROFILE_FILENAMES = new String[]{"profiles%s.yml", "profiles%s.yaml", "profiles%s"};
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    public static final String DEFAULT_PROFILE = "default";
    public static final ProcessorConfigurationExtractor GENERATOR_CONFIG = new ProcessorConfigurationExtractor(){

        @Override
        public ProcessorConfig extract(Profile profile) {
            return profile.getGeneratorConfig();
        }
    };
    public static final ProcessorConfigurationExtractor ENRICHER_CONFIG = new ProcessorConfigurationExtractor(){

        @Override
        public ProcessorConfig extract(Profile profile) {
            return profile.getEnricherConfig();
        }
    };
    public static final ProcessorConfigurationExtractor WATCHER_CONFIG = new ProcessorConfigurationExtractor(){

        @Override
        public ProcessorConfig extract(Profile profile) {
            return profile.getWatcherConfig();
        }
    };

    private ProfileUtil() {
    }

    public static Profile findProfile(String profileArg, File resourceDir) throws IOException {
        try {
            String profile = profileArg == null ? DEFAULT_PROFILE : profileArg;
            Profile profileFound = ProfileUtil.lookup(profile, resourceDir);
            if (profileFound != null) {
                return profileFound;
            }
            throw new IllegalArgumentException("No profile '" + profile + "' defined");
        }
        catch (IOException e) {
            throw new IOException("Error while looking up profile " + profileArg + ": " + e.getMessage(), e);
        }
    }

    public static ProcessorConfig blendProfileWithConfiguration(ProcessorConfigurationExtractor configExtractor, String profile, File resourceDir, ProcessorConfig config) throws IOException {
        ProcessorConfig profileConfig = ProfileUtil.extractProcesssorConfiguration(configExtractor, profile, resourceDir);
        return ProcessorConfig.mergeProcessorConfigs(profileConfig, config);
    }

    public static Profile lookup(String name, File directory) throws IOException {
        List<Profile> profiles = ProfileUtil.readProfileFromClasspath(name);
        File profileFile = ProfileUtil.findProfileYaml(directory);
        if (profileFile != null) {
            List<Profile> fileProfiles = ProfileUtil.fromYaml(new FileInputStream(profileFile));
            for (Profile profile : fileProfiles) {
                if (!profile.getName().equals(name)) continue;
                profiles.add(profile);
                break;
            }
        }
        Collections.sort(profiles);
        return ProfileUtil.mergeProfiles(profiles);
    }

    private static ProcessorConfig extractProcesssorConfiguration(ProcessorConfigurationExtractor extractor, String profile, File resourceDir) throws IOException {
        Profile profileFound = ProfileUtil.findProfile(profile, resourceDir);
        return extractor.extract(profileFound);
    }

    private static Profile mergeProfiles(List<Profile> profiles) {
        Profile ret = null;
        for (Profile profile : profiles) {
            if (profile == null) continue;
            if (ret == null) {
                ret = new Profile(profile);
                continue;
            }
            ret = new Profile(ret, profile);
        }
        return ret;
    }

    private static List<Profile> readProfileFromClasspath(String name) throws IOException {
        ArrayList<Profile> ret = new ArrayList<Profile>();
        ret.addAll(ProfileUtil.readAllFromClasspath(name, DEFAULT_PROFILE));
        ret.addAll(ProfileUtil.readAllFromClasspath(name, ""));
        return ret;
    }

    public static List<Profile> readAllFromClasspath(String name, String ext) throws IOException {
        ArrayList<Profile> ret = new ArrayList<Profile>();
        for (String location : ProfileUtil.getMetaInfProfilePaths(ext)) {
            for (String url : ClassUtil.getResources(location)) {
                for (Profile profile : ProfileUtil.fromYaml(new URL(url).openStream())) {
                    if (!name.equals(profile.getName())) continue;
                    ret.add(profile);
                }
            }
        }
        return ret;
    }

    private static File findProfileYaml(File directory) {
        for (String profileFile : PROFILE_FILENAMES) {
            File ret = new File(directory, String.format(profileFile, ""));
            if (!ret.exists()) continue;
            return ret;
        }
        return null;
    }

    private static List<String> getMetaInfProfilePaths(String ext) {
        ArrayList<String> ret = new ArrayList<String>(PROFILE_FILENAMES.length);
        for (String p : PROFILE_FILENAMES) {
            ret.add("META-INF/fabric8/" + ProfileUtil.getProfileFileName(p, ext));
        }
        return ret;
    }

    private static String getProfileFileName(String fileName, String ext) {
        return String.format(fileName, StringUtils.isNotBlank((String)ext) ? "-" + ext : "");
    }

    public static List<Profile> fromYaml(InputStream is) throws IOException {
        TypeReference<List<Profile>> typeRef = new TypeReference<List<Profile>>(){};
        return (List)mapper.readValue(is, (TypeReference)typeRef);
    }

    public static interface ProcessorConfigurationExtractor {
        public ProcessorConfig extract(Profile var1);
    }
}

