/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import io.fabric8.maven.core.config.ProbeConfig;
import io.fabric8.maven.core.util.Commandline;
import io.fabric8.utils.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class ProbeHandler {
    public Probe getProbe(ProbeConfig probeConfig) {
        HTTPGetAction getAction;
        Integer timeoutSeconds;
        if (probeConfig == null) {
            return null;
        }
        Probe probe = new Probe();
        Integer initialDelaySeconds = probeConfig.getInitialDelaySeconds();
        if (initialDelaySeconds != null) {
            probe.setInitialDelaySeconds(initialDelaySeconds);
        }
        if ((timeoutSeconds = probeConfig.getTimeoutSeconds()) != null) {
            probe.setTimeoutSeconds(timeoutSeconds);
        }
        if ((getAction = this.getHTTPGetAction(probeConfig.getGetUrl())) != null) {
            probe.setHttpGet(getAction);
            return probe;
        }
        ExecAction execAction = this.getExecAction(probeConfig.getExec());
        if (execAction != null) {
            probe.setExec(execAction);
            return probe;
        }
        TCPSocketAction tcpSocketAction = this.getTCPSocketAction(probeConfig.getTcpPort());
        if (tcpSocketAction != null) {
            probe.setTcpSocket(tcpSocketAction);
            return probe;
        }
        return null;
    }

    private HTTPGetAction getHTTPGetAction(String getUrl) {
        if (getUrl == null) {
            return null;
        }
        try {
            URL url = new URL(getUrl);
            return new HTTPGetAction(url.getHost(), null, url.getPath(), new IntOrString(Integer.valueOf(url.getPort())), url.getProtocol());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL " + getUrl + " given for HTTP GET readiness check");
        }
    }

    private TCPSocketAction getTCPSocketAction(String port) {
        if (port != null) {
            IntOrString portObj = new IntOrString(port);
            try {
                Integer portInt = Integer.parseInt(port);
                portObj.setIntVal(portInt);
            }
            catch (NumberFormatException e) {
                portObj.setStrVal(port);
            }
            return new TCPSocketAction(portObj);
        }
        return null;
    }

    private ExecAction getExecAction(String execCmd) {
        List<String> splitCommandLine;
        if (Strings.isNotBlank((String)execCmd) && !(splitCommandLine = Commandline.translateCommandline(execCmd)).isEmpty()) {
            return new ExecAction(splitCommandLine);
        }
        return null;
    }
}

