/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.maven.core.config.ProcessorConfig;
import io.fabric8.maven.core.config.Profile;
import io.fabric8.maven.core.util.ClassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileUtil {
    public static final String[] PROFILE_FILENAMES = new String[]{"profiles.yml", "profiles.yaml", "profiles"};
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    public static final ProcessorConfigurationExtractor GENERATOR_CONFIG = new ProcessorConfigurationExtractor(){

        @Override
        public ProcessorConfig extract(Profile profile) {
            ProcessorConfig processorConfig = profile.getGeneratorConfig();
            return processorConfig != null ? processorConfig : ProcessorConfig.INCLUDE_ALL;
        }
    };
    public static final ProcessorConfigurationExtractor ENRICHER_CONFIG = new ProcessorConfigurationExtractor(){

        @Override
        public ProcessorConfig extract(Profile profile) {
            ProcessorConfig processorConfig = profile.getEnricherConfig();
            return processorConfig != null ? processorConfig : ProcessorConfig.INCLUDE_ALL;
        }
    };

    public static Profile findProfile(String profile, File resourceDir) throws IOException {
        try {
            if (profile != null) {
                Profile profileFound = ProfileUtil.lookup(profile, resourceDir);
                if (profileFound != null) {
                    return profileFound;
                }
                throw new IllegalArgumentException("No profile " + profile + " defined");
            }
        }
        catch (IOException e) {
            throw new IOException("Error while looking up profile " + profile + ": " + e.getMessage(), e);
        }
        return null;
    }

    public static ProcessorConfig extractProcesssorConfiguration(ProcessorConfigurationExtractor extractor, String profile, File resourceDir) throws IOException {
        Profile profileFound = ProfileUtil.findProfile(profile, resourceDir);
        if (profileFound != null) {
            return extractor.extract(profileFound);
        }
        return ProcessorConfig.INCLUDE_ALL;
    }

    public static Map<String, Profile> readAllFromClasspath() throws IOException {
        HashMap<String, Profile> ret = new HashMap<String, Profile>();
        for (String location : ProfileUtil.getMetaInfProfilePaths()) {
            for (String url : ClassUtil.getResources(location)) {
                for (Profile profile : ProfileUtil.fromYaml(new URL(url).openStream())) {
                    ret.put(profile.getName(), profile);
                }
            }
        }
        return ret;
    }

    public static Profile lookup(String name, File directory) throws IOException {
        File profileFile = ProfileUtil.findProfileYaml(directory);
        if (profileFile != null) {
            List<Profile> profiles = ProfileUtil.fromYaml(new FileInputStream(profileFile));
            for (Profile profile : profiles) {
                if (!profile.getName().equals(name)) continue;
                return profile;
            }
        }
        return ProfileUtil.readAllFromClasspath().get(name);
    }

    private static File findProfileYaml(File directory) {
        for (String profileFile : PROFILE_FILENAMES) {
            File ret = new File(directory, profileFile);
            if (!ret.exists()) continue;
            return ret;
        }
        return null;
    }

    private static List<String> getMetaInfProfilePaths() {
        ArrayList<String> ret = new ArrayList<String>(PROFILE_FILENAMES.length);
        for (String p : PROFILE_FILENAMES) {
            ret.add("META-INF/fabric8/" + p);
        }
        return ret;
    }

    public static List<Profile> fromYaml(InputStream is) throws IOException {
        TypeReference<List<Profile>> typeRef = new TypeReference<List<Profile>>(){};
        return (List)mapper.readValue(is, (TypeReference)typeRef);
    }

    public static interface ProcessorConfigurationExtractor {
        public ProcessorConfig extract(Profile var1);
    }
}

