/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.kubernetes;

import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.utils.Objects;

public class DockerBuildService
implements BuildService {
    private ServiceHub dockerServiceHub;
    private BuildService.BuildServiceConfig config;

    public DockerBuildService(ServiceHub dockerServiceHub, BuildService.BuildServiceConfig config) {
        Objects.notNull((Object)dockerServiceHub, (String)"dockerServiceHub");
        Objects.notNull((Object)config, (String)"config");
        this.dockerServiceHub = dockerServiceHub;
        this.config = config;
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws Fabric8ServiceException {
        io.fabric8.maven.docker.service.BuildService dockerBuildService = this.dockerServiceHub.getBuildService();
        BuildService.BuildContext dockerBuildContext = this.config.getDockerBuildContext();
        try {
            dockerBuildService.buildImage(imageConfig, dockerBuildContext);
            dockerBuildService.tagImage(imageConfig.getName(), imageConfig);
        }
        catch (Exception ex) {
            throw new Fabric8ServiceException("Error while trying to build the image", ex);
        }
    }

    @Override
    public void postProcess(BuildService.BuildServiceConfig config) {
    }
}

