/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Scaleable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

public class KubernetesClientUtil {
    public static void resizeApp(KubernetesClient kubernetes, String namespace, Set<HasMetadata> entities, int replicas, Logger log) {
        for (HasMetadata entity : entities) {
            String name = KubernetesHelper.getName((HasMetadata)entity);
            Scaleable scalable = null;
            if (entity instanceof Deployment) {
                scalable = (Scaleable)((NonNamespaceOperation)kubernetes.extensions().deployments().inNamespace(namespace)).withName(name);
            } else if (entity instanceof ReplicaSet) {
                scalable = (Scaleable)((NonNamespaceOperation)kubernetes.extensions().replicaSets().inNamespace(namespace)).withName(name);
            } else if (entity instanceof ReplicationController) {
                scalable = (Scaleable)((NonNamespaceOperation)kubernetes.replicationControllers().inNamespace(namespace)).withName(name);
            } else if (entity instanceof DeploymentConfig) {
                OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
                if (openshiftClient == null) {
                    log.warn("Ignoring DeploymentConfig %s as not connected to an OpenShift cluster", new Object[]{name});
                    continue;
                }
                scalable = (Scaleable)((NonNamespaceOperation)openshiftClient.deploymentConfigs().inNamespace(namespace)).withName(name);
            }
            if (scalable == null) continue;
            log.info("Scaling " + KubernetesHelper.getKind((HasMetadata)entity) + " " + namespace + "/" + name + " to replicas: " + replicas, new Object[0]);
            scalable.scale(replicas, true);
        }
    }

    public static void deleteEntities(KubernetesClient kubernetes, String namespace, Set<HasMetadata> entities, String s2iBuildNameSuffix, Logger log) {
        ArrayList<HasMetadata> list = new ArrayList<HasMetadata>(entities);
        OpenShiftClient openshiftClient = new Controller(kubernetes).getOpenShiftClientOrNull();
        if (openshiftClient != null) {
            for (HasMetadata entity : list) {
                if (!"ImageStream".equals(KubernetesHelper.getKind((HasMetadata)entity))) continue;
                ImageName imageName = new ImageName(entity.getMetadata().getName());
                String buildName = KubernetesClientUtil.getS2IBuildName(imageName, s2iBuildNameSuffix);
                log.info("Deleting resource BuildConfig " + namespace + "/" + buildName, new Object[0]);
                ((BuildConfigResource)((NonNamespaceOperation)openshiftClient.buildConfigs().inNamespace(namespace)).withName(buildName)).delete();
            }
        }
        Collections.reverse(list);
        for (HasMetadata entity : list) {
            log.info("Deleting resource " + KubernetesHelper.getKind((HasMetadata)entity) + " " + namespace + "/" + KubernetesHelper.getName((HasMetadata)entity), new Object[0]);
            ((Deletable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)kubernetes.resource(entity).inNamespace(namespace)).cascading(true)).delete();
        }
    }

    private static String getS2IBuildName(ImageName imageName, String s2iBuildNameSuffix) {
        return imageName.getSimpleName() + s2iBuildNameSuffix;
    }

    public static FilterWatchListDeletable<Pod, PodList, Boolean, Watch, Watcher<Pod>> withSelector(NonNamespaceOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods, LabelSelector selector, Logger log) {
        List matchExpressions;
        FilterWatchListDeletable answer = pods;
        Map matchLabels = selector.getMatchLabels();
        if (matchLabels != null && !matchLabels.isEmpty()) {
            answer = (FilterWatchListDeletable)answer.withLabels(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block8: for (LabelSelectorRequirement expression : matchExpressions) {
                String operator;
                String key = expression.getKey();
                List values = expression.getValues();
                if (Strings.isNullOrBlank((String)key)) {
                    log.warn("Ignoring empty key in selector expression %s", new Object[]{expression});
                    continue;
                }
                if (values == null || values.isEmpty()) {
                    log.warn("Ignoring empty values in selector expression %s", new Object[]{expression});
                    continue;
                }
                String[] valuesArray = values.toArray(new String[values.size()]);
                switch (operator = expression.getOperator()) {
                    case "In": {
                        answer = (FilterWatchListDeletable)answer.withLabelIn(key, valuesArray);
                        continue block8;
                    }
                    case "NotIn": {
                        answer = (FilterWatchListDeletable)answer.withLabelNotIn(key, valuesArray);
                        continue block8;
                    }
                }
                log.warn("Ignoring unknown operator %s in selector expression %s", new Object[]{operator, expression});
            }
        }
        return answer;
    }

    public static void printLogsAsync(LogWatch logWatcher, final String failureMessage, final CountDownLatch terminateLatch, final Logger log) {
        final InputStream in = logWatcher.getOutput();
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            return;
                        }
                        if (terminateLatch.getCount() <= 0L) {
                            return;
                        }
                        log.info("[[s]]%s", new Object[]{line});
                        continue;
                        break;
                    }
                }
                catch (IOException e) {
                    if (terminateLatch.getCount() <= 0L) return;
                    log.error("%s : %s", new Object[]{failureMessage, e});
                    return;
                }
            }
        };
        thread.start();
    }

    public static String getPodStatusDescription(Pod pod) {
        return KubernetesHelper.getPodStatusText((Pod)pod) + " " + KubernetesClientUtil.getPodCondition(pod);
    }

    public static String getPodStatusMessagePostfix(Watcher.Action action) {
        String message = "";
        switch (action) {
            case DELETED: {
                message = ": Pod Deleted";
                break;
            }
            case ERROR: {
                message = ": Error";
            }
        }
        return message;
    }

    protected static String getPodCondition(Pod pod) {
        PodStatus podStatus = pod.getStatus();
        if (podStatus == null) {
            return "";
        }
        List conditions = podStatus.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return "";
        }
        for (PodCondition condition : conditions) {
            String statusText;
            String type = condition.getType();
            if (!Strings.isNotBlank((String)type) || !"ready".equalsIgnoreCase(type) || !Strings.isNotBlank((String)(statusText = condition.getStatus())) || !Boolean.parseBoolean(statusText)) continue;
            return type;
        }
        return "";
    }
}

