/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.maven.core.util.KindAndName;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.docker.util.Logger;
import java.util.HashMap;
import java.util.Map;

public class OpenShiftOverrideResources {
    private final Map<KindAndName, HasMetadata> map = new HashMap<KindAndName, HasMetadata>();
    private final Logger log;

    public OpenShiftOverrideResources(Logger log) {
        this.log = log;
    }

    public void addOpenShiftOverride(HasMetadata item) {
        KindAndName key = new KindAndName(item);
        this.map.put(key, item);
    }

    public HasMetadata overrideResource(HasMetadata item) {
        KindAndName key = new KindAndName(item);
        HasMetadata override = this.map.get(key);
        if (override != null) {
            this.log.info("Overriding " + key, new Object[0]);
            HasMetadata answer = KubernetesResourceUtil.mergeResources(item, override, this.log, false);
            if (answer != null) {
                return answer;
            }
        }
        return item;
    }
}

