/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.maven.core.handler.ContainerHandler;
import io.fabric8.maven.core.handler.DaemonSetHandler;
import io.fabric8.maven.core.handler.DeploymentHandler;
import io.fabric8.maven.core.handler.EnvVarHandler;
import io.fabric8.maven.core.handler.JobHandler;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.handler.ProbeHandler;
import io.fabric8.maven.core.handler.ReplicaSetHandler;
import io.fabric8.maven.core.handler.ReplicationControllerHandler;
import io.fabric8.maven.core.handler.ServiceHandler;
import io.fabric8.maven.core.handler.StatefulSetHandler;
import org.apache.maven.project.MavenProject;

public class HandlerHub {
    private final ServiceHandler serviceHandler;
    private final ReplicaSetHandler replicaSetHandler;
    private final ReplicationControllerHandler replicationControllerHandler;
    private final DeploymentHandler deploymentHandler;
    private final StatefulSetHandler statefulSetHandler;
    private final DaemonSetHandler daemonSetHandler;
    private final JobHandler jobHandler;

    public HandlerHub(MavenProject project) {
        ProbeHandler probeHandler = new ProbeHandler();
        EnvVarHandler envVarHandler = new EnvVarHandler(project);
        ContainerHandler containerHandler = new ContainerHandler(project, envVarHandler, probeHandler);
        PodTemplateHandler podTemplateHandler = new PodTemplateHandler(containerHandler);
        this.deploymentHandler = new DeploymentHandler(podTemplateHandler);
        this.replicaSetHandler = new ReplicaSetHandler(podTemplateHandler);
        this.replicationControllerHandler = new ReplicationControllerHandler(podTemplateHandler);
        this.serviceHandler = new ServiceHandler();
        this.statefulSetHandler = new StatefulSetHandler(podTemplateHandler);
        this.daemonSetHandler = new DaemonSetHandler(podTemplateHandler);
        this.jobHandler = new JobHandler(podTemplateHandler);
    }

    public ServiceHandler getServiceHandler() {
        return this.serviceHandler;
    }

    public DeploymentHandler getDeploymentHandler() {
        return this.deploymentHandler;
    }

    public ReplicaSetHandler getReplicaSetHandler() {
        return this.replicaSetHandler;
    }

    public ReplicationControllerHandler getReplicationControllerHandler() {
        return this.replicationControllerHandler;
    }

    public StatefulSetHandler getStatefulSetHandler() {
        return this.statefulSetHandler;
    }

    public DaemonSetHandler getDaemonSetHandler() {
        return this.daemonSetHandler;
    }

    public JobHandler getJobHandler() {
        return this.jobHandler;
    }
}

