/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service;

import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.core.util.ProcessUtil;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.maven.shared.utils.io.FileUtils;
import org.apache.maven.shared.utils.io.IOUtil;

public class ComposeService {
    public static final String KOMPOSE_RESOURCES_DIRECTORY = "kompose_resources";
    private File defaultKomposeBinDir;
    private Path komposeResourcesPath;
    private Path composeFilePath;
    private Logger log;
    private Process process;

    public ComposeService(File defaultKomposeBinDir, Path composeFilePath, Logger log) {
        this.defaultKomposeBinDir = defaultKomposeBinDir;
        this.composeFilePath = composeFilePath;
        this.log = log;
    }

    public File[] convertToKubeFragments() throws Fabric8ServiceException {
        File[] komposeResourceFiles = new File[]{};
        if (this.composeFilePath != null) {
            this.log.info("converting docker compose file %s to kubernetes resource descriptors", new Object[]{this.composeFilePath});
            try {
                this.initializeKompose();
                this.invokeKompose();
                komposeResourceFiles = this.handelKomposeResult();
            }
            catch (IOException e) {
                throw new Fabric8ServiceException(e);
            }
            this.log.info("conversion completed successfully : %s resource descriptors generated", new Object[]{komposeResourceFiles.length});
        }
        return komposeResourceFiles;
    }

    private void initializeKompose() throws IOException {
        this.komposeResourcesPath = Files.createTempDirectory(KOMPOSE_RESOURCES_DIRECTORY, new FileAttribute[0]);
    }

    private void invokeKompose() throws Fabric8ServiceException {
        try {
            String executableName = "kompose";
            File komposeBinaryFile = ProcessUtil.findExecutable(this.log, executableName);
            if (komposeBinaryFile == null && this.defaultKomposeBinDir != null) {
                komposeBinaryFile = ProcessUtil.findExecutable(this.log, executableName, Collections.singletonList(this.defaultKomposeBinDir));
            }
            if (komposeBinaryFile == null) {
                this.log.error("[[B]]kompose[[B]] utility doesn't exist, please execute [[B]]mvn fabric8:install[[B]] command to make it work", new Object[0]);
                this.log.error("or", new Object[0]);
                this.log.error("to install it manually, please log on to [[B]]http://kompose.io/installation/[[B]]", new Object[0]);
                this.cleanComposeResources();
                throw new Fabric8ServiceException("Cannot find the kompose binary in PATH or default install location");
            }
            this.process = Runtime.getRuntime().exec(new String[]{komposeBinaryFile.getAbsolutePath(), "convert", "-o", this.komposeResourcesPath.toString(), "-f", this.composeFilePath.toString()});
        }
        catch (IOException exp) {
            this.cleanComposeResources();
            throw new Fabric8ServiceException(exp.getMessage(), exp);
        }
        this.waitForConversion();
    }

    private File[] handelKomposeResult() throws IOException, Fabric8ServiceException {
        if (this.process.exitValue() != 0) {
            StringWriter stringWriter = new StringWriter();
            IOUtil.copy((InputStream)this.process.getErrorStream(), (Writer)stringWriter);
            this.log.error("conversion failed : " + stringWriter.toString(), new Object[0]);
            throw new Fabric8ServiceException(stringWriter.toString());
        }
        this.process = null;
        return this.komposeResourcesPath.toFile().listFiles();
    }

    public void cleanComposeResources() {
        if (this.komposeResourcesPath == null) {
            return;
        }
        try {
            FileUtils.deleteDirectory((File)this.komposeResourcesPath.toFile());
        }
        catch (IOException e) {
            this.log.warn("kompose clean up failed: %s", new Object[]{e.getMessage()});
        }
    }

    private void waitForConversion() throws Fabric8ServiceException {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            this.log.error("kompose process interrupted: %s", new Object[]{e.getMessage()});
            throw new Fabric8ServiceException(e);
        }
    }

    public Path getPath() {
        return this.komposeResourcesPath;
    }
}

