/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.openshift;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.builds.Builds;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.maven.core.access.ClusterAccess;
import io.fabric8.maven.core.config.OpenShiftBuildStrategy;
import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.core.service.openshift.ImageStreamService;
import io.fabric8.maven.core.util.IoUtil;
import io.fabric8.maven.core.util.KubernetesClientUtil;
import io.fabric8.maven.core.util.KubernetesResourceUtil;
import io.fabric8.maven.core.util.ResourceFileType;
import io.fabric8.maven.docker.assembly.ArchiverCustomizer;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpec;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.tar.TarArchiver;

public class OpenshiftBuildService
implements BuildService {
    private final OpenShiftClient client;
    private final Logger log;
    private ServiceHub dockerServiceHub;
    private BuildService.BuildServiceConfig config;
    private ClusterAccess clusterAccess;
    private static final int RESOURCE_CREATION_RETRIES = 5;
    private static final int RESOURCE_CREATION_RETRY_TIMEOUT_IN_MILLIS = 1000;

    public OpenshiftBuildService(OpenShiftClient client, Logger log, ServiceHub dockerServiceHub, BuildService.BuildServiceConfig config) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(log, "log");
        Objects.requireNonNull(dockerServiceHub, "dockerServiceHub");
        Objects.requireNonNull(config, "config");
        this.client = client;
        this.log = log;
        this.dockerServiceHub = dockerServiceHub;
        this.config = config;
        this.clusterAccess = new ClusterAccess(null);
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws Fabric8ServiceException {
        try {
            ImageName imageName = new ImageName(imageConfig.getName());
            File dockerTar = this.createBuildArchive(imageConfig);
            KubernetesListBuilder builder = new KubernetesListBuilder();
            String buildName = this.updateOrCreateBuildConfig(this.config, this.client, builder, imageConfig);
            this.checkOrCreateImageStream(this.config, this.client, builder, this.getImageStreamName(imageName));
            this.applyResourceObjects(this.config, this.client, builder);
            Build build = this.startBuild(this.client, dockerTar, buildName);
            this.waitForOpenShiftBuildToComplete(this.client, build);
            this.addImageStreamToFile(this.getImageStreamFile(this.config), imageName, this.client);
        }
        catch (Fabric8ServiceException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new Fabric8ServiceException("Unable to build the image using the OpenShift build service", ex);
        }
    }

    protected File createBuildArchive(ImageConfiguration imageConfig) throws Fabric8ServiceException {
        ArchiverCustomizer customizer = this.getS2ICustomizer(imageConfig);
        try {
            File dockerTar = customizer != null ? this.dockerServiceHub.getArchiveService().createDockerBuildArchive(imageConfig, this.config.getDockerMojoParameters(), customizer) : this.dockerServiceHub.getArchiveService().createDockerBuildArchive(imageConfig, this.config.getDockerMojoParameters());
            return dockerTar;
        }
        catch (MojoExecutionException e) {
            throw new Fabric8ServiceException("Unable to create the build archive", e);
        }
    }

    private ArchiverCustomizer getS2ICustomizer(ImageConfiguration imageConfiguration) throws Fabric8ServiceException {
        try {
            if (imageConfiguration.getBuildConfiguration() != null && imageConfiguration.getBuildConfiguration().getEnv() != null) {
                String fileName = IoUtil.sanitizeFileName("s2i-env-" + imageConfiguration.getName());
                final File environmentFile = new File(this.config.getBuildDirectory(), fileName);
                try (PrintWriter out = new PrintWriter(new FileWriter(environmentFile));){
                    for (Map.Entry e : imageConfiguration.getBuildConfiguration().getEnv().entrySet()) {
                        out.println((String)e.getKey() + "=" + (String)e.getValue());
                    }
                }
                return new ArchiverCustomizer(){

                    public TarArchiver customize(TarArchiver tarArchiver) throws IOException {
                        tarArchiver.addFile(environmentFile, ".s2i/environment");
                        return tarArchiver;
                    }
                };
            }
            return null;
        }
        catch (IOException e) {
            throw new Fabric8ServiceException("Unable to add environment variables to the S2I build archive", e);
        }
    }

    private File getImageStreamFile(BuildService.BuildServiceConfig config) {
        return ResourceFileType.yaml.addExtension(new File(config.getBuildDirectory(), String.format("%s-is", config.getArtifactId())));
    }

    @Override
    public void postProcess(BuildService.BuildServiceConfig config) {
        config.attachArtifact("is", this.getImageStreamFile(config));
    }

    private String updateOrCreateBuildConfig(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, ImageConfiguration imageConfig) {
        ImageName imageName = new ImageName(imageConfig.getName());
        String buildName = this.getS2IBuildName(config, imageName);
        String imageStreamName = this.getImageStreamName(imageName);
        String outputImageStreamTag = imageStreamName + ":" + (imageName.getTag() != null ? imageName.getTag() : "latest");
        BuildStrategy buildStrategyResource = this.createBuildStrategy(imageConfig, config.getOpenshiftBuildStrategy());
        BuildOutput buildOutput = ((BuildOutputBuilder)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)new BuildOutputBuilder().withNewTo().withKind("ImageStreamTag")).withName(outputImageStreamTag)).endTo()).build();
        BuildConfig buildConfig = (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).get();
        if (buildConfig != null) {
            BuildConfigSpec spec = this.getBuildConfigSpec(buildConfig);
            this.validateSourceType(buildName, spec);
            if (config.getBuildRecreateMode().isBuildConfig()) {
                ((BuildConfigResource)client.buildConfigs().withName(buildName)).delete();
                return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
            }
            return this.updateBuildConfig(client, buildName, buildStrategyResource, buildOutput, spec);
        }
        return this.createBuildConfig(builder, buildName, buildStrategyResource, buildOutput);
    }

    private void validateSourceType(String buildName, BuildConfigSpec spec) {
        String sourceType;
        BuildSource source = spec.getSource();
        if (source != null && !Objects.equals("Binary", sourceType = source.getType())) {
            this.log.warn("BuildServiceConfig %s is not of type: 'Binary' but is '%s' !", new Object[]{buildName, sourceType});
        }
    }

    private BuildConfigSpec getBuildConfigSpec(BuildConfig buildConfig) {
        BuildConfigSpec spec = buildConfig.getSpec();
        if (spec == null) {
            spec = new BuildConfigSpec();
            buildConfig.setSpec(spec);
        }
        return spec;
    }

    private String createBuildConfig(KubernetesListBuilder builder, String buildName, BuildStrategy buildStrategyResource, BuildOutput buildOutput) {
        this.log.info("Creating BuildServiceConfig %s for %s build", new Object[]{buildName, buildStrategyResource.getType()});
        ((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BaseKubernetesListFluent.BuildConfigItemsNested)((BuildConfigFluent.MetadataNested)builder.addNewBuildConfigItem().withNewMetadata().withName(buildName)).endMetadata()).withNewSpec().withNewSource().withType("Binary")).endSource()).withStrategy(buildStrategyResource)).withOutput(buildOutput)).endSpec()).endBuildConfigItem();
        return buildName;
    }

    private String updateBuildConfig(OpenShiftClient client, String buildName, BuildStrategy buildStrategy, BuildOutput buildOutput, BuildConfigSpec spec) {
        if (!Objects.equals(buildStrategy, spec.getStrategy()) || !Objects.equals(buildOutput, spec.getOutput())) {
            ((DoneableBuildConfig)((BuildConfigFluent.SpecNested)((BuildConfigFluent.SpecNested)((DoneableBuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).edit()).editSpec().withStrategy(buildStrategy)).withOutput(buildOutput)).endSpec()).done();
            this.log.info("Updating BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        } else {
            this.log.info("Using BuildServiceConfig %s for %s strategy", new Object[]{buildName, buildStrategy.getType()});
        }
        return buildName;
    }

    private BuildStrategy createBuildStrategy(ImageConfiguration imageConfig, OpenShiftBuildStrategy osBuildStrategy) {
        if (osBuildStrategy == OpenShiftBuildStrategy.docker) {
            return ((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Docker")).build();
        }
        if (osBuildStrategy == OpenShiftBuildStrategy.s2i) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            Map fromExt = buildConfig.getFromExt();
            String fromName = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.name, buildConfig.getFrom());
            String fromKind = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.kind, "DockerImage");
            String fromNamespace = this.getMapValueWithDefault((Map<String, String>)fromExt, OpenShiftBuildStrategy.SourceStrategy.namespace, "ImageStreamTag".equals(fromKind) ? "openshift" : null);
            return ((BuildStrategyBuilder)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildStrategyBuilder)new BuildStrategyBuilder().withType("Source")).withNewSourceStrategy().withNewFrom().withKind(fromKind)).withName(fromName)).withNamespace(StringUtils.isEmpty((CharSequence)fromNamespace) ? null : fromNamespace)).endFrom()).endSourceStrategy()).build();
        }
        throw new IllegalArgumentException("Unsupported BuildStrategy " + (Object)((Object)osBuildStrategy));
    }

    private void checkOrCreateImageStream(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder, String imageStreamName) {
        boolean hasImageStream;
        boolean bl = hasImageStream = ((Resource)client.imageStreams().withName(imageStreamName)).get() != null;
        if (hasImageStream && config.getBuildRecreateMode().isImageStream()) {
            ((Resource)client.imageStreams().withName(imageStreamName)).delete();
            hasImageStream = false;
        }
        if (!hasImageStream) {
            this.log.info("Creating ImageStream %s", new Object[]{imageStreamName});
            ((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.LookupPolicyNested)((BaseKubernetesListFluent.ImageStreamItemsNested)((ImageStreamFluent.MetadataNested)builder.addNewImageStreamItem().withNewMetadata().withName(imageStreamName)).endMetadata()).withNewSpec().withNewLookupPolicy().withLocal(Boolean.valueOf(config.isS2iImageStreamLookupPolicyLocal()))).endLookupPolicy()).endSpec()).endImageStreamItem();
        } else {
            this.log.info("Adding to ImageStream %s", new Object[]{imageStreamName});
        }
    }

    private void applyResourceObjects(BuildService.BuildServiceConfig config, OpenShiftClient client, KubernetesListBuilder builder) throws Exception {
        int nTries = 0;
        boolean bResourcesCreated = false;
        Exception buildException = null;
        do {
            try {
                if (config.getEnricherTask() != null) {
                    config.getEnricherTask().execute((Object)builder);
                }
                if (builder.hasItems().booleanValue()) {
                    KubernetesList k8sList = builder.build();
                    client.lists().create((Object[])new KubernetesList[]{k8sList});
                }
                bResourcesCreated = true;
            }
            catch (Exception aException) {
                if (aException.getMessage() != null && aException.getMessage().contains("Socket closed")) {
                    this.log.warn("Problem encountered while applying resource objects, retrying..", new Object[0]);
                    buildException = aException;
                    ++nTries;
                    Thread.sleep(1000L);
                    client = (OpenShiftClient)this.clusterAccess.createDefaultClient(this.log);
                    continue;
                }
                throw new MojoExecutionException(aException.getMessage());
            }
        } while (nTries < 5 && !bResourcesCreated);
        if (!bResourcesCreated) {
            throw new MojoExecutionException(buildException.getMessage());
        }
    }

    private Build startBuild(OpenShiftClient client, File dockerTar, String buildName) {
        this.log.info("Starting Build %s", new Object[]{buildName});
        try {
            return (Build)((BuildConfigResource)client.buildConfigs().withName(buildName)).instantiateBinary().fromFile(dockerTar);
        }
        catch (KubernetesClientException exp) {
            Status status = exp.getStatus();
            if (status != null) {
                this.log.error("OpenShift Error: [%d %s] [%s] %s", new Object[]{status.getCode(), status.getStatus(), status.getReason(), status.getMessage()});
            }
            if (exp.getCause() instanceof IOException && exp.getCause().getMessage().contains("Stream Closed")) {
                this.log.error("Build for %s failed: %s", new Object[]{buildName, exp.getCause().getMessage()});
                this.logBuildBuildFailedDetails(client, buildName);
            }
            throw exp;
        }
    }

    private void waitForOpenShiftBuildToComplete(OpenShiftClient client, Build build) throws MojoExecutionException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch logTerminateLatch = new CountDownLatch(1);
        String buildName = KubernetesHelper.getName((HasMetadata)build);
        AtomicReference<Build> buildHolder = new AtomicReference<Build>();
        this.waitUntilPodIsReady(buildName + "-build", 20, this.log);
        this.log.info("Waiting for build " + buildName + " to complete...", new Object[0]);
        try (LogWatch logWatch = (LogWatch)((PodResource)client.pods().withName(buildName + "-build")).watchLog();){
            KubernetesClientUtil.printLogsAsync(logWatch, "Failed to tail build log", logTerminateLatch, this.log);
            Watcher<Build> buildWatcher = this.getBuildWatcher(latch, buildName, buildHolder);
            try (Watch watcher = (Watch)((BuildResource)client.builds().withName(buildName)).watch(buildWatcher);){
                String status;
                Build lastBuild = (Build)((BuildResource)client.builds().withName(buildName)).get();
                if (Builds.isFinished((String)KubernetesResourceUtil.getBuildStatusPhase(lastBuild))) {
                    this.log.debug("Build %s is already finished", new Object[]{buildName});
                    buildHolder.set(lastBuild);
                    latch.countDown();
                }
                this.waitUntilBuildFinished(latch);
                logTerminateLatch.countDown();
                build = buildHolder.get();
                if (build == null) {
                    this.log.debug("Build watcher on %s was closed prematurely", new Object[]{buildName});
                    build = (Build)((BuildResource)client.builds().withName(buildName)).get();
                }
                if (Builds.isFailed((String)(status = KubernetesResourceUtil.getBuildStatusPhase(build))) || Builds.isCancelled((String)status)) {
                    throw new MojoExecutionException("OpenShift Build " + buildName + " error: " + KubernetesResourceUtil.getBuildStatusReason(build));
                }
                if (!Builds.isFinished((String)status)) {
                    this.log.warn("Could not wait for the completion of build %s. It may be  may be still running (status=%s)", new Object[]{buildName, status});
                } else {
                    this.log.info("Build %s in status %s", new Object[]{buildName, status});
                }
            }
        }
    }

    private void waitUntilPodIsReady(String podName, int nAwaitTimeout, Logger log) throws InterruptedException {
        final CountDownLatch readyLatch = new CountDownLatch(1);
        try (Watch watch = (Watch)((PodResource)this.client.pods().withName(podName)).watch((Object)new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod aPod) {
                if (KubernetesHelper.isPodReady((Pod)aPod)) {
                    readyLatch.countDown();
                }
            }

            public void onClose(KubernetesClientException e) {
            }
        });){
            readyLatch.await(nAwaitTimeout, TimeUnit.SECONDS);
        }
        catch (KubernetesClientException | InterruptedException e) {
            log.error("Could not watch pod", new Object[]{e});
        }
    }

    private void waitUntilBuildFinished(CountDownLatch latch) {
        while (latch.getCount() > 0L) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Watcher<Build> getBuildWatcher(final CountDownLatch latch, final String buildName, final AtomicReference<Build> buildHolder) {
        return new Watcher<Build>(){
            String lastStatus = "";

            public void eventReceived(Watcher.Action action, Build build) {
                buildHolder.set(build);
                String status = KubernetesResourceUtil.getBuildStatusPhase(build);
                OpenshiftBuildService.this.log.verbose("BuildWatch: Received event %s , build status: %s", new Object[]{action, build.getStatus()});
                if (!this.lastStatus.equals(status)) {
                    this.lastStatus = status;
                    OpenshiftBuildService.this.log.verbose("Build %s status: %s", new Object[]{buildName, status});
                }
                if (Builds.isFinished((String)status)) {
                    latch.countDown();
                }
            }

            public void onClose(KubernetesClientException cause) {
                if (cause != null) {
                    OpenshiftBuildService.this.log.error("Error while watching for build to finish: %s [%d]", new Object[]{cause.getMessage(), cause.getCode()});
                    Status status = cause.getStatus();
                    if (status != null) {
                        OpenshiftBuildService.this.log.error("%s [%s]", new Object[]{status.getReason(), status.getStatus()});
                    }
                }
                latch.countDown();
            }
        };
    }

    private void logBuildBuildFailedDetails(OpenShiftClient client, String buildName) {
        try {
            BuildConfig build = (BuildConfig)((BuildConfigResource)client.buildConfigs().withName(buildName)).get();
            ObjectReference ref = build.getSpec().getStrategy().getSourceStrategy().getFrom();
            String kind = ref.getKind();
            String name = ref.getName();
            if ("DockerImage".equals(kind)) {
                this.log.error("Please, ensure that the Docker image '%s' exists and is accessible by OpenShift", new Object[]{name});
            } else if ("ImageStreamTag".equals(kind)) {
                String namespace = ref.getNamespace();
                String namespaceInfo = "current";
                String namespaceParams = "";
                if (namespace != null && !namespace.isEmpty()) {
                    namespaceInfo = "'" + namespace + "'";
                    namespaceParams = " -n " + namespace;
                }
                this.log.error("Please, ensure that the ImageStream Tag '%s' exists in the %s namespace (with 'oc get is%s')", new Object[]{name, namespaceInfo, namespaceParams});
            }
        }
        catch (Exception ex) {
            this.log.error("Unable to get detailed information from the BuildServiceConfig: " + ex.getMessage(), new Object[0]);
        }
    }

    private void addImageStreamToFile(File imageStreamFile, ImageName imageName, OpenShiftClient client) throws MojoExecutionException {
        ImageStreamService imageStreamHandler = new ImageStreamService(client, this.log);
        imageStreamHandler.appendImageStreamResource(imageName, imageStreamFile);
    }

    private String getS2IBuildName(BuildService.BuildServiceConfig config, ImageName imageName) {
        return imageName.getSimpleName() + config.getS2iBuildNameSuffix();
    }

    private String getImageStreamName(ImageName name) {
        return name.getSimpleName();
    }

    private String getMapValueWithDefault(Map<String, String> map, OpenShiftBuildStrategy.SourceStrategy strategy, String defaultValue) {
        return this.getMapValueWithDefault(map, strategy.key(), defaultValue);
    }

    private String getMapValueWithDefault(Map<String, String> map, String field, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        String value = map.get(field);
        return value != null ? value : defaultValue;
    }
}

