/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootConfigurationHelper.class);
    public static final String SPRING_BOOT_GROUP_ID = "org.springframework.boot";
    public static final String SPRING_BOOT_ARTIFACT_ID = "spring-boot";
    public static final String SPRING_BOOT_DEVTOOLS_ARTIFACT_ID = "spring-boot-devtools";
    public static final String DEV_TOOLS_REMOTE_SECRET = "spring.devtools.remote.secret";
    public static final String DEV_TOOLS_REMOTE_SECRET_ENV = "SPRING_DEVTOOLS_REMOTE_SECRET";
    private static final String[] MANAGEMENT_PORT = new String[]{"management.port", "management.server.port"};
    private static final String[] SERVER_PORT = new String[]{"server.port", "server.port"};
    private static final String[] SERVER_KEYSTORE = new String[]{"server.ssl.key-store", "server.ssl.key-store"};
    private static final String[] MANAGEMENT_KEYSTORE = new String[]{"management.ssl.key-store", "management.server.ssl.key-store"};
    private static final String[] SERVLET_PATH = new String[]{"server.servlet-path", "server.servlet.path"};
    private static final String[] SERVER_CONTEXT_PATH = new String[]{"server.context-path", "server.servlet.context-path"};
    private static final String[] MANAGEMENT_CONTEXT_PATH = new String[]{"management.context-path", "management.server.servlet.context-path"};
    private static final String[] ACTUATOR_BASE_PATH = new String[]{null, "management.endpoints.web.base-path"};
    private static final String[] ACTUATOR_DEFAULT_BASE_PATH = new String[]{"", "/actuator"};
    private int propertyOffset;

    public SpringBootConfigurationHelper(String springBootVersion) {
        this.propertyOffset = this.propertyOffset(springBootVersion);
    }

    public String getManagementPortPropertyKey() {
        return this.lookup(MANAGEMENT_PORT);
    }

    public String getServerPortPropertyKey() {
        return this.lookup(SERVER_PORT);
    }

    public String getServerKeystorePropertyKey() {
        return this.lookup(SERVER_KEYSTORE);
    }

    public String getManagementKeystorePropertyKey() {
        return this.lookup(MANAGEMENT_KEYSTORE);
    }

    public String getServletPathPropertyKey() {
        return this.lookup(SERVLET_PATH);
    }

    public String getServerContextPathPropertyKey() {
        return this.lookup(SERVER_CONTEXT_PATH);
    }

    public String getManagementContextPathPropertyKey() {
        return this.lookup(MANAGEMENT_CONTEXT_PATH);
    }

    public String getActuatorBasePathPropertyKey() {
        return this.lookup(ACTUATOR_BASE_PATH);
    }

    public String getActuatorDefaultBasePath() {
        return this.lookup(ACTUATOR_DEFAULT_BASE_PATH);
    }

    private String lookup(String[] keys) {
        return keys[this.propertyOffset];
    }

    private int propertyOffset(String springBootVersion) {
        Integer majorVersion = this.majorVersion(springBootVersion);
        int idx = majorVersion != null ? majorVersion - 1 : 0;
        idx = Math.min(idx, 1);
        idx = Math.max(idx, 0);
        return idx;
    }

    private Integer majorVersion(String version) {
        if (version != null) {
            try {
                return Integer.parseInt(version.substring(0, version.indexOf(".")));
            }
            catch (Exception e) {
                LOG.warn("Cannot spring boot major version from {}", (Object)version);
            }
        }
        return null;
    }
}

