/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util.validator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import io.fabric8.maven.core.util.ResourceClassifier;
import io.fabric8.maven.core.util.validator.IgnorePortValidationRule;
import io.fabric8.maven.core.util.validator.IgnoreResourceMemoryLimitRule;
import io.fabric8.maven.core.util.validator.ValidationRule;
import io.fabric8.maven.docker.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceValidator {
    public static final String SCHEMA_JSON = "/schema/kube-validation-schema.json";
    private Logger log;
    private File[] resources;
    private ResourceClassifier target = ResourceClassifier.KUBERNETES;
    private List<ValidationRule> ignoreValidationRules = new ArrayList<ValidationRule>();

    public ResourceValidator(File inputFile) {
        this.resources = inputFile.isDirectory() ? inputFile.listFiles() : new File[]{inputFile};
    }

    public ResourceValidator(File inputFile, ResourceClassifier target, Logger log) {
        this(inputFile);
        this.target = target;
        this.log = log;
        this.setupIgnoreRules(this.target);
    }

    private void setupIgnoreRules(ResourceClassifier target) {
        this.ignoreValidationRules.add(new IgnorePortValidationRule("type"));
        this.ignoreValidationRules.add(new IgnoreResourceMemoryLimitRule("type"));
    }

    public int validate() throws ConstraintViolationException, IOException {
        for (File resource : this.resources) {
            if (!resource.isFile() || !resource.exists()) continue;
            try {
                this.log.info("validating %s resource", new Object[]{resource.toString()});
                JsonNode inputSpecNode = this.geFileContent(resource);
                String kind = inputSpecNode.get("kind").toString();
                JsonSchema schema = this.getJsonSchema(this.prepareSchemaUrl(SCHEMA_JSON), kind);
                Set errors = schema.validate(inputSpecNode);
                this.processErrors(errors, resource);
            }
            catch (JSONException e) {
                throw new ConstraintViolationException(e.getMessage(), new HashSet());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return this.resources.length;
    }

    private void processErrors(Set<ValidationMessage> errors, File resource) {
        HashSet<ConstraintViolationImpl> constraintViolations = new HashSet<ConstraintViolationImpl>();
        for (ValidationMessage errorMsg : errors) {
            if (this.ignoreError(errorMsg)) continue;
            constraintViolations.add(new ConstraintViolationImpl(errorMsg));
        }
        if (constraintViolations.size() > 0) {
            throw new ConstraintViolationException(this.getErrorMessage(resource, constraintViolations), constraintViolations);
        }
    }

    private boolean ignoreError(ValidationMessage errorMsg) {
        for (ValidationRule rule : this.ignoreValidationRules) {
            if (!rule.ignore(errorMsg)) continue;
            return true;
        }
        return false;
    }

    private String getErrorMessage(File resource, Set<ConstraintViolationImpl> violations) {
        StringBuilder validationError = new StringBuilder();
        validationError.append("Invalid Resource : ");
        validationError.append(resource.toString());
        for (ConstraintViolationImpl violation : violations) {
            validationError.append("\n");
            validationError.append(violation.toString());
        }
        return validationError.toString();
    }

    private JsonSchema getJsonSchema(URI schemaUrl, String kind) throws IOException {
        this.checkIfKindPropertyExists(kind);
        JsonSchemaFactory factory = new JsonSchemaFactory();
        JSONObject jsonSchema = this.getSchemaJson(schemaUrl);
        this.getResourceProperties(kind, jsonSchema);
        return factory.getSchema(jsonSchema.toString());
    }

    private void getResourceProperties(String kind, JSONObject jsonSchema) {
        jsonSchema.put("properties", (Object)jsonSchema.getJSONObject("resources").getJSONObject(kind.replaceAll("\"", "").toLowerCase()).getJSONObject("properties"));
    }

    private void checkIfKindPropertyExists(String kind) {
        if (kind == null) {
            throw new JSONException("Invalid kind of resource or 'kind' is missing from resource definition");
        }
    }

    private URI prepareSchemaUrl(String schemaFile) throws URISyntaxException {
        return this.getClass().getResource(schemaFile).toURI();
    }

    private JsonNode geFileContent(File file) throws IOException {
        try (FileInputStream resourceStream = new FileInputStream(file);){
            ObjectMapper jsonMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode jsonNode = jsonMapper.readTree((InputStream)resourceStream);
            return jsonNode;
        }
    }

    public JSONObject getSchemaJson(URI schemaUrl) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        String rootNode = ((JsonNode)objectMapper.readValue(schemaUrl.toURL(), JsonNode.class)).toString();
        JSONObject jsonObject = new JSONObject(rootNode);
        jsonObject.remove("id");
        return jsonObject;
    }

    private class ConstraintViolationImpl
    implements ConstraintViolation<ValidationMessage> {
        private ValidationMessage errorMsg;

        public ConstraintViolationImpl(ValidationMessage errorMsg) {
            this.errorMsg = errorMsg;
        }

        public String getMessage() {
            return this.errorMsg.getMessage();
        }

        public String getMessageTemplate() {
            return null;
        }

        public ValidationMessage getRootBean() {
            return null;
        }

        public Class<ValidationMessage> getRootBeanClass() {
            return null;
        }

        public Object getLeafBean() {
            return null;
        }

        public Object[] getExecutableParameters() {
            return new Object[0];
        }

        public Object getExecutableReturnValue() {
            return null;
        }

        public Path getPropertyPath() {
            return null;
        }

        public Object getInvalidValue() {
            return null;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return null;
        }

        public <U> U unwrap(Class<U> aClass) {
            return null;
        }

        public String toString() {
            return "[message=" + this.getMessage().replaceFirst("[$]", "") + ", violation type=" + this.errorMsg.getType() + "]";
        }
    }
}

