/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman;

import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.PolicyFailureType;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.fabric8.gateway.api.CallDetailRecord;
import io.fabric8.gateway.api.apimanager.ApiManagerService;
import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.HttpMapping;
import io.fabric8.gateway.apiman.VertxBuffer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class ApiManHttpGatewayHandler
implements Handler<HttpServerRequest> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ApiManHttpGatewayHandler.class);
    private final HttpGateway httpGateway;
    private final ApiManagerService apiManager;

    public ApiManHttpGatewayHandler(Vertx vertx, HttpGateway httpGateway, ApiManagerService apiManager) {
        this.httpGateway = httpGateway;
        LOG.info("HTTP Requests are routed via APIMan");
        this.apiManager = apiManager;
    }

    public void handle(final HttpServerRequest request) {
        final long callStart = System.nanoTime();
        if (HttpMapping.isMappingIndexRequest((HttpServerRequest)request, (HttpGateway)this.httpGateway)) {
            HttpMapping.respond((HttpServerRequest)request, (HttpGateway)this.httpGateway);
            return;
        }
        ServiceRequest srequest = new ServiceRequest();
        srequest.setRawRequest((Object)request);
        srequest.setApiKey(this.getApiKey(request));
        srequest.setType(request.method());
        srequest.setRemoteAddr(request.remoteAddress().getAddress().getHostAddress());
        srequest.setDestination(request.path());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : request.headers().names()) {
            headerMap.put(key, request.headers().get(key));
        }
        srequest.setHeaders(headerMap);
        final HttpServerResponse response = request.response();
        IEngine engine = (IEngine)this.apiManager.getEngine();
        IServiceRequestExecutor requestExecutor = engine.executor(srequest, (IAsyncResultHandler)new IAsyncResultHandler<IEngineResult>(){

            public void handle(IAsyncResult<IEngineResult> iAsyncEngineResult) {
                if (!iAsyncEngineResult.isSuccess()) {
                    response.setStatusCode(500);
                    response.setStatusMessage("Gateway Internal Error: " + iAsyncEngineResult.getError().getMessage());
                    response.close();
                    LOG.error("Gateway Internal Error " + iAsyncEngineResult.getError().getMessage());
                } else {
                    IEngineResult engineResult = (IEngineResult)iAsyncEngineResult.getResult();
                    if (engineResult.isFailure()) {
                        ServiceResponse serviceResponse = engineResult.getServiceResponse();
                        if (serviceResponse != null) {
                            HttpClient finalClient = (HttpClient)serviceResponse.getAttribute("finalClient");
                            finalClient.close();
                        }
                        PolicyFailure policyFailure = engineResult.getPolicyFailure();
                        response.putHeader("X-Policy-Failure-Type", String.valueOf(policyFailure.getType()));
                        response.putHeader("X-Policy-Failure-Message", policyFailure.getMessage());
                        response.putHeader("X-Policy-Failure-Code", String.valueOf(policyFailure.getFailureCode()));
                        int errorCode = 403;
                        if (policyFailure.getType() == PolicyFailureType.Authentication) {
                            errorCode = 401;
                        } else if (policyFailure.getType() == PolicyFailureType.Authorization) {
                            errorCode = 401;
                        }
                        response.setStatusCode(errorCode);
                        response.setStatusMessage(policyFailure.getMessage());
                        response.end();
                        response.close();
                    } else if (engineResult.isResponse()) {
                        ServiceResponse serviceResponse = engineResult.getServiceResponse();
                        response.setStatusCode(serviceResponse.getCode());
                        response.setStatusMessage(serviceResponse.getMessage());
                        response.setChunked(true);
                        engineResult.bodyHandler((IAsyncHandler)new IAsyncHandler<IApimanBuffer>(){

                            public void handle(IApimanBuffer chunk) {
                                response.write((Buffer)chunk.getNativeBuffer());
                            }
                        });
                        engineResult.endHandler((IAsyncHandler)new IAsyncHandler<Void>(){

                            public void handle(Void flag) {
                                LOG.debug("ResponseCode from downstream " + response.getStatusCode());
                                CallDetailRecord cdr = new CallDetailRecord(System.nanoTime() - callStart, response.getStatusMessage());
                                ApiManHttpGatewayHandler.this.httpGateway.addCallDetailRecord(cdr);
                                response.end();
                                response.close();
                                LOG.debug("Complete success, and closed the client connection.");
                            }
                        });
                    }
                }
            }
        });
        requestExecutor.streamHandler((IAsyncHandler)new IAsyncHandler<ISignalWriteStream>(){

            public void handle(final ISignalWriteStream writeStream) {
                request.dataHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer data) {
                        VertxBuffer apimanBuffer = new VertxBuffer(data);
                        writeStream.write((IApimanBuffer)apimanBuffer);
                    }
                });
                writeStream.end();
            }
        });
        requestExecutor.execute();
    }

    protected String getApiKey(HttpServerRequest request) {
        String apiKey = request.headers().get("X-API-Key");
        if (apiKey == null || apiKey.trim().length() == 0) {
            apiKey = this.getApiKeyFromQuery(request);
        }
        return apiKey;
    }

    protected String getApiKeyFromQuery(HttpServerRequest request) {
        String queryString = request.query();
        if (queryString == null) {
            return null;
        }
        int idx = queryString.indexOf("apikey=");
        if (idx >= 0) {
            int endIdx = queryString.indexOf(38, idx);
            if (endIdx == -1) {
                endIdx = queryString.length();
            }
            return queryString.substring(idx + 7, endIdx);
        }
        return null;
    }
}

