/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman;

import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.fabric8.gateway.apiman.VertxBuffer;
import java.util.HashMap;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientResponse;

public class ApiManHttpServiceResponseHandler
implements Handler<HttpClientResponse> {
    final HttpClient httpClient;
    final IAsyncHandler<IAsyncResult<IServiceConnectionResponse>> apiManServiceResponseHandler;

    public ApiManHttpServiceResponseHandler(HttpClient httpClient, IAsyncHandler<IAsyncResult<IServiceConnectionResponse>> responseHandler) {
        this.httpClient = httpClient;
        this.apiManServiceResponseHandler = responseHandler;
    }

    public void handle(final HttpClientResponse clientResponse) {
        clientResponse.pause();
        final ServiceResponse serviceResponse = new ServiceResponse();
        serviceResponse.setCode(clientResponse.statusCode());
        serviceResponse.setMessage(clientResponse.statusMessage());
        serviceResponse.setAttribute("clientResponse", (Object)clientResponse);
        serviceResponse.setAttribute("httpClient", (Object)this.httpClient);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : clientResponse.headers().names()) {
            headerMap.put(key, clientResponse.headers().get(key));
        }
        serviceResponse.setHeaders(headerMap);
        IServiceConnectionResponse streamToClient = new IServiceConnectionResponse(){
            private boolean streamFinished = false;

            public void transmit() {
                clientResponse.resume();
            }

            public ServiceResponse getHead() {
                return serviceResponse;
            }

            public void abort() {
            }

            public void bodyHandler(final IAsyncHandler<IApimanBuffer> bodyHandler) {
                clientResponse.dataHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer chunk) {
                        bodyHandler.handle((Object)new VertxBuffer(chunk));
                    }
                });
            }

            public void endHandler(final IAsyncHandler<Void> endHandler) {
                clientResponse.endHandler((Handler)new VoidHandler(){

                    protected void handle() {
                        streamFinished = true;
                        endHandler.handle(null);
                    }
                });
            }

            public boolean isFinished() {
                return this.streamFinished;
            }
        };
        AsyncResultImpl result = AsyncResultImpl.create((Object)streamToClient);
        this.apiManServiceResponseHandler.handle((Object)result);
    }
}

