/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.apiman;

import io.apiman.gateway.engine.IServiceConnectionResponse;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.fabric8.gateway.api.apimanager.ApiManagerService;
import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.apiman.ApiManEngine;
import io.fabric8.gateway.apiman.ApiManHttpGatewayHandler;
import io.fabric8.gateway.apiman.ApiManHttpServiceResponseHandler;
import io.fabric8.gateway.apiman.ApiManRestRequestHandler;
import io.fabric8.gateway.apiman.Engine;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;

@ApplicationScoped
public class ApiManService
implements ApiManagerService {
    private static final transient Logger LOG = LoggerFactory.getLogger(ApiManService.class);
    private Vertx vertx;
    private HttpGateway httpGateway;
    private ApiManEngine engine;
    private HttpServer engineRestServer;
    public static final String ATTR_HTTP_CLIENT = "httpClient";
    public static final String ATTR_CLIENT_RESPONSE = "clientResponse";

    public void init(Map<String, Object> config) {
        LOG.info("Initializing the ApiMan Engine..");
        this.vertx = (Vertx)config.get("vertx");
        this.httpGateway = (HttpGateway)config.get("httpGateway");
        String port = (String)config.get("port");
        this.engine = new Engine().create(this.vertx, this.httpGateway, port);
        this.engineRestServer = this.vertx.createHttpServer();
        int portRest = Integer.valueOf(port) - 1;
        if (config.containsKey("port.rest")) {
            portRest = (Integer)config.get("port.rest");
        }
        this.engineRestServer.requestHandler((Handler)new ApiManRestRequestHandler(this.engine));
        this.engineRestServer.listen(portRest, "localhost");
        LOG.info("The ApiMan REST Service is listening at on port " + portRest);
    }

    @PreDestroy
    public void deactivateComponent() {
        this.engineRestServer.close();
        this.engineRestServer = null;
        this.engine = null;
    }

    public Object getEngine() {
        return this.engine;
    }

    public Handler<HttpClientResponse> createServiceResponseHandler(HttpClient httpClient, Object apiManagementResponseHandler) {
        return new ApiManHttpServiceResponseHandler(httpClient, (IAsyncHandler<IAsyncResult<IServiceConnectionResponse>>)((IAsyncHandler)apiManagementResponseHandler));
    }

    public Handler<HttpServerRequest> createApiManagerHttpGatewayHandler() {
        return new ApiManHttpGatewayHandler(this.vertx, this.httpGateway, this);
    }
}

